<?php
session_start();
require_once 'db.php';

if (!isset($_SESSION['registration_data'])) {
    header('Location: index.php');
    exit;
}

$data = $_SESSION['registration_data'];
$nom_complet = $data['prenom'] . ' ' . $data['nom'];
$payment_success = isset($_GET['payment']) && $_GET['payment'] === 'success';

if (!$payment_success && $data['cadeau'] == 0) {
    $email_subject = "Confirmation - A Sixteen Dream";
    $email_body = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: #000; color: #fff; padding: 30px; text-align: center; }
            .content { padding: 30px; background: #f9f9f9; }
            .footer { padding: 20px; text-align: center; font-size: 12px; color: #666; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1 style='margin:0; font-weight: 100; font-size: 32px;'>A Sixteen Dream</h1>
            </div>
            <div class='content'>
                <h2>Bienvenue {$nom_complet} !</h2>
                <p>Ton inscription pour A Sixteen Dream est confirmée.</p>
                
                <h3>Détails de l'événement :</h3>
                <p>
                    <strong>Date :</strong> Vendredi 20 Mars 2025<br>
                    <strong>Horaire :</strong> 18h30 - 02h00<br>
                    <strong>Lieu :</strong> Château de la Hulpe - Chaussée de Bruxelles 111, 1310 La Hulpe
                </p>
                
                <p>À très bientôt !</p>
            </div>
            <div class='footer'>
                <p>Présenté par Imators</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=utf-8\r\n";
    $headers .= "From: A Sixteen Dream <no-reply@imators.com>\r\n";
    
    mail($data['email'], $email_subject, $email_body, $headers);
    
    $sms_message = "Merci {$data['prenom']} ! Ton inscription pour A Sixteen Dream est confirmée. RDV le 20 Mars 2025 à 18h30 au Château de la Hulpe. - Imators";
    
    $ch = curl_init('https://textbelt.com/text');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'phone' => $data['telephone'],
        'message' => $sms_message,
        'key' => '65cc7a4af9b5db94cdbc332fcc2704e7e86604fakMlbReRxuZa89bOISbQ9YIi6G'
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
}

$montant_paye = null;
if ($payment_success && isset($data['stripe_session_id'])) {
    try {
        require_once 'vendor/autoload.php';
        \Stripe\Stripe::setApiKey('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');
        $intent = \Stripe\PaymentIntent::retrieve($data['stripe_session_id']);
        $montant_paye = $intent->amount / 100;
    } catch (Exception $e) {
        error_log('Erreur récupération montant: ' . $e->getMessage());
    }
}

session_destroy();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inscription Confirmée - A Sixteen Dream</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-black text-white">
    <div class="px-8 py-16 max-w-3xl mx-auto text-center">
        <div class="w-16 h-16 bg-green-600 rounded-full flex items-center justify-center mx-auto mb-8">
            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
        </div>
        
        <h1 class="text-5xl font-light mb-6" style="font-weight: 100;">C'est confirmé !</h1>
        
        <?php if ($payment_success): ?>
            <p class="text-xl opacity-90 mb-8 font-light">
                Merci <strong><?php echo htmlspecialchars($nom_complet); ?></strong> ! 
                Ton inscription est confirmée et ton cadeau pour Izhak a été traité avec succès.
            </p>
        <?php else: ?>
            <p class="text-xl opacity-90 mb-8 font-light">
                Parfait <strong><?php echo htmlspecialchars($nom_complet); ?></strong> ! 
                Ton inscription pour "A Sixteen Dream" est confirmée.
            </p>
        <?php endif; ?>
        
        <div class="bg-gray-900 rounded-lg p-6 mb-8 text-left">
            <h3 class="text-xl font-light mb-4 text-center" style="font-weight: 300;">Récapitulatif</h3>
            <div class="space-y-2 text-sm font-light">
                <p><strong>Nom :</strong> <?php echo htmlspecialchars($data['nom']); ?></p>
                <p><strong>Prénom :</strong> <?php echo htmlspecialchars($data['prenom']); ?></p>
                <p><strong>Email :</strong> <?php echo htmlspecialchars($data['email']); ?></p>
                <p><strong>Téléphone :</strong> <?php echo htmlspecialchars($data['telephone']); ?></p>
                
                <?php if ($data['enfant'] && !empty($data['nombre_enfants'])): ?>
                    <p><strong>Enfants :</strong> <?php echo htmlspecialchars($data['nombre_enfants']); ?> enfant(s)</p>
                <?php endif; ?>
                
                <?php if ($data['conjoint'] && !empty($data['prenom_conjoint'])): ?>
                    <p><strong>Accompagnant :</strong> <?php echo htmlspecialchars($data['prenom_conjoint'] . ' ' . $data['nom_conjoint']); ?></p>
                <?php endif; ?>
                
                <?php if ($data['parking'] && !empty($data['type_vehicule'])): ?>
                    <p><strong>Parking :</strong> <?php echo htmlspecialchars(ucfirst($data['type_vehicule'])); ?></p>
                <?php endif; ?>
                
                <?php if (!empty($data['preferences_alimentaires'])): ?>
                    <p><strong>Régime :</strong> <?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $data['preferences_alimentaires']))); ?></p>
                <?php endif; ?>
                
                <?php if ($payment_success && $montant_paye): ?>
                    <p class="pt-2 border-t border-gray-700"><strong>Cadeau :</strong> <span class="text-green-400">✓ Payé (<?php echo number_format($montant_paye, 2); ?> €)</span></p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="bg-gray-800 rounded-lg p-6 mb-8">
            <h4 class="font-light mb-2 text-lg">🎉 A Sixteen Dream</h4>
            <p class="opacity-75 text-sm font-light">
                <strong>Vendredi 20 Mars 2025</strong> • 18h30 - 02h00<br>
                Château de la Hulpe - Chaussée de Bruxelles 111, 1310 La Hulpe
            </p>
        </div>
        
        <p class="opacity-75 mb-8 text-sm font-light">
            Tu recevras un email et un SMS de confirmation avec tous les détails pratiques pour la soirée.
        </p>
        
        <a href="index.php" class="bg-white text-black font-light py-3 px-8 inline-block hover:bg-gray-200 transition-colors text-xs tracking-wider">
            RETOUR À L'ACCUEIL
        </a>
    </div>
</body>
</html>