<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Can Algorithm - License Key Generator</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            font-weight: 300;
        }
        .gradient-text {
            background: linear-gradient(135deg, #ffffff 0%, #a1a1aa 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .form-card {
            background: #0a0a0a;
            border: 1px solid #1a1a1a;
        }
        .input-field {
            background: #111111;
            border: 1px solid #333333;
            transition: all 0.3s ease;
        }
        .input-field:focus {
            border-color: #666666;
            outline: none;
        }
        .btn-primary {
            background: linear-gradient(135deg, #333333 0%, #1a1a1a 100%);
            border: 1px solid #444444;
            transition: all 0.3s ease;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #444444 0%, #2a2a2a 100%);
            border-color: #666666;
        }
        .success-card {
            background: #0a2e0a;
            border: 1px solid #1a4a1a;
        }
    </style>
</head>
<body class="bg-black text-white min-h-screen">
    <div class="max-w-3xl mx-auto px-8 py-16">
        
        <header class="text-center mb-16">
            <h1 class="text-5xl mb-4 gradient-text font-medium">Get Your License Key</h1>
            <p class="text-lg text-gray-300 mb-2">Can Algorithm - Free License</p>
            <p class="text-sm text-gray-500">Generate your free license key to unlock Can Algorithm</p>
        </header>

        <section class="mb-12">
            <div class="form-card rounded-lg p-8 max-w-2xl mx-auto">
                <h3 class="text-xl mb-6 text-center">Generate License Key</h3>
                
                <form id="licenseForm" class="space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">First Name</label>
                            <input type="text" id="firstName" required class="input-field w-full p-3 rounded text-white">
                        </div>
                        <div>
                            <label class="block text-sm text-gray-400 mb-2">Last Name</label>
                            <input type="text" id="lastName" required class="input-field w-full p-3 rounded text-white">
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">Email Address</label>
                        <input type="email" id="email" required class="input-field w-full p-3 rounded text-white">
                    </div>
                    
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">Company (Optional)</label>
                        <input type="text" id="company" class="input-field w-full p-3 rounded text-white">
                    </div>
                    
                    <button type="submit" class="btn-primary w-full p-4 rounded font-medium">
                        Generate Free License Key
                    </button>
                </form>
            </div>
        </section>

        <section id="successSection" class="mb-12 hidden">
            <div class="success-card rounded-lg p-8 max-w-2xl mx-auto text-center">
                <h3 class="text-xl mb-4 text-green-400">License Generated Successfully!</h3>
                
                <div class="bg-black rounded p-4 mb-6">
                    <div class="text-sm text-gray-400 mb-2">Your License Key:</div>
                    <div id="generatedKey" class="text-lg font-mono text-white mb-2"></div>
                    <button id="copyKey" class="text-xs text-gray-400 hover:text-white">Click to copy</button>
                </div>
                
                <div class="text-sm text-gray-300 mb-4">
                    <strong>Installation Steps:</strong>
                    <ol class="text-left mt-2 space-y-1">
                        <li>1. Install: <code class="bg-black px-2 py-1 rounded">npm install -g can-algorithm</code></li>
                        <li>2. Configure: <code class="bg-black px-2 py-1 rounded">can genconfig</code></li>
                        <li>3. Enter your license key when prompted</li>
                        <li>4. Start using: <code class="bg-black px-2 py-1 rounded">can scan</code></li>
                    </ol>
                </div>
                
                <div class="text-xs text-gray-500">
                    Save this license key safely. You'll need it to configure Can Algorithm.<br>
                    Need help? Visit <a href="https://imators.systems/can" class="text-gray-300">imators.systems/can</a>
                </div>
            </div>
        </section>

        <footer class="text-center border-t border-gray-800 pt-8">
            <div class="text-xs text-gray-600">
                © 2025 <a href="https://imators.systems" class="text-gray-400 hover:text-white">Imators</a>. All rights reserved.
            </div>
        </footer>

    </div>

    <script>
        document.getElementById('licenseForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const firstName = document.getElementById('firstName').value;
            const lastName = document.getElementById('lastName').value;
            const email = document.getElementById('email').value;
            const company = document.getElementById('company').value;
            
            const licenseKey = generateLicenseKey(firstName, lastName, email);
            
            const licenseData = {
                key: licenseKey,
                firstName: firstName,
                lastName: lastName,
                email: email,
                company: company,
                generated: new Date().toISOString(),
                status: 'active'
            };
            
            console.log('Generated license:', licenseData);
            
            document.getElementById('generatedKey').textContent = licenseKey;
            document.getElementById('successSection').classList.remove('hidden');
            
            this.style.display = 'none';
            
            document.getElementById('successSection').scrollIntoView({ behavior: 'smooth' });
        });

        document.getElementById('copyKey').addEventListener('click', function() {
            const key = document.getElementById('generatedKey').textContent;
            navigator.clipboard.writeText(key).then(() => {
                this.textContent = 'Copied!';
                setTimeout(() => {
                    this.textContent = 'Click to copy';
                }, 2000);
            });
        });

        function generateLicenseKey(firstName, lastName, email) {
            const segments = [];
            
            // Generate 3 segments of 4 characters each
            for (let i = 0; i < 3; i++) {
                let segment = '';
                
                // Mix user data with random for each segment
                const seedData = firstName + lastName + email + Date.now().toString() + i.toString();
                const hash = hashCode(seedData + Math.random().toString());
                
                // Generate 4 alphanumeric characters
                for (let j = 0; j < 4; j++) {
                    const chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    const index = Math.abs(hash + j * 7) % chars.length;
                    segment += chars[index];
                    
                    // Additional randomization
                    if (Math.random() > 0.5) {
                        const randomIndex = Math.floor(Math.random() * chars.length);
                        segment = segment.slice(0, -1) + chars[randomIndex];
                    }
                }
                
                segments.push(segment);
            }
            
            return `CAN-${segments.join('-')}`;
        }

        function hashCode(str) {
            let hash = 0;
            for (let i = 0; i < str.length; i++) {
                const char = str.charCodeAt(i);
                hash = ((hash << 5) - hash) + char;
                hash = hash & hash;
            }
            return Math.abs(hash);
        }
    </script>
</body>
</html>