<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['merchant_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

require_once '../config/db_comm.php';

$merchant_id = $_SESSION['merchant_id'];
$today = date('Y-m-d');

try {
    $stmt = $pdo_comm->prepare("SELECT setting_key, setting_value FROM settings");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    $current_hour = (int)date('H');
    $in_time_window = $current_hour >= $settings['start_hour'] && $current_hour < $settings['end_hour'];
    
    $stmt = $pdo_comm->prepare("SELECT COUNT(*) FROM notifications_log WHERE merchant_id = ? AND DATE(sent_at) = ?");
    $stmt->execute([$merchant_id, $today]);
    $notifications_sent = $stmt->fetchColumn();
    $notifications_remaining = max(0, $settings['notification_limit_daily'] - $notifications_sent);
    
    $stmt = $pdo_comm->prepare("SELECT COUNT(*) FROM emails_log WHERE merchant_id = ? AND DATE(sent_at) = ?");
    $stmt->execute([$merchant_id, $today]);
    $emails_sent = $stmt->fetchColumn();
    $emails_remaining = max(0, $settings['email_limit_daily'] - $emails_sent);
    
    $stmt = $pdo_comm->prepare("SELECT sent_at FROM emails_log WHERE merchant_id = ? AND DATE(sent_at) = ? ORDER BY sent_at DESC LIMIT 1");
    $stmt->execute([$merchant_id, $today]);
    $last_email = $stmt->fetchColumn();
    
    $email_cooldown = false;
    if ($last_email) {
        $cooldown_minutes = $settings['email_cooldown_hours'] * 60;
        $time_diff = (time() - strtotime($last_email)) / 60;
        $email_cooldown = $time_diff < $cooldown_minutes;
    }
    
    $stmt = $pdo_comm->prepare("SELECT COUNT(*) FROM system_messages WHERE merchant_id = ? AND read_at IS NULL");
    $stmt->execute([$merchant_id]);
    $unread_messages = $stmt->fetchColumn();
    
    $stmt = $pdo_comm->prepare("SELECT COUNT(*) FROM shop_updates WHERE merchant_id = ? AND status = 'pending'");
    $stmt->execute([$merchant_id]);
    $pending_updates = $stmt->fetchColumn();
    
    echo json_encode([
        'success' => true,
        'counters' => [
            'notifications_remaining' => $notifications_remaining,
            'emails_remaining' => $emails_remaining,
            'in_time_window' => $in_time_window,
            'email_cooldown' => $email_cooldown
        ],
        'system' => [
            'ios_enabled' => (bool)$settings['ios_enabled'],
            'android_enabled' => (bool)$settings['android_enabled']
        ],
        'messages' => [
            'unread' => $unread_messages
        ],
        'shop_updates' => [
            'pending' => $pending_updates
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur']);
}
?>