<?php
include 'db.php';

$query = $pdo->query("SELECT `title`, `description`, `link`, `image-cover`, `price` FROM a17");
$items = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gemance</title>
    <link rel="icon" href="https://cdn.imators.com/logo_Gemance.png" type="image/x-icon">
    <meta name="description" content="Gemance is a brand offering you the opportunity to buy exceptional, rare and one-of-a-kind jewelry.">

    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="https://gemance.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Gemance">
    <meta property="og:description" content="Gemance is a brand offering you the opportunity to buy exceptional, rare and one-of-a-kind jewelry.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/7d08cca6-56aa-42d1-a641-f9f44914ea12.png?token=jXDBoGRjIgGiGA3pNhDAtPJ8odoJIiQ_1zznvH6RNR0&height=630&width=1200&expires=33258602552">

    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="gemance.com">
    <meta property="twitter:url" content="https://gemance.com">
    <meta name="twitter:title" content="Gemance">
    <meta name="twitter:description" content="Gemance is a brand offering you the opportunity to buy exceptional, rare and one-of-a-kind jewelry.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/7d08cca6-56aa-42d1-a641-f9f44914ea12.png?token=jXDBoGRjIgGiGA3pNhDAtPJ8odoJIiQ_1zznvH6RNR0&height=630&width=1200&expires=33258602552">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
    <style>
        /* Styles Merriweather */
        .merriweather-light { font-family: "Merriweather", serif; font-weight: 300; font-style: normal; }
        .merriweather-regular { font-family: "Merriweather", serif; font-weight: 400; font-style: normal; }
        .merriweather-bold { font-family: "Merriweather", serif; font-weight: 700; font-style: normal; }
        .merriweather-black { font-family: "Merriweather", serif; font-weight: 900; font-style: normal; }
        .merriweather-light-italic { font-family: "Merriweather", serif; font-weight: 300; font-style: italic; }
        .merriweather-regular-italic { font-family: "Merriweather", serif; font-weight: 400; font-style: italic; }
        .merriweather-bold-italic { font-family: "Merriweather", serif; font-weight: 700; font-style: italic; }
        .merriweather-black-italic { font-family: "Merriweather", serif; font-weight: 900; font-style: italic; }

        /* Styles pour l'overlay */
        #image-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.9);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        #overlay-image {
            max-width: 90%;
            max-height: 90%;
            object-fit: contain;
        }
    </style>
</head>
<body class="bg-black text-white">

<div id="hamburger-icon" class="fixed bottom-4 right-4 opacity-0 transition-opacity duration-500">
    <a href="../menu" class="block w-16 h-16 bg-white rounded-full shadow-lg flex items-center justify-center">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-8 h-8 text-gray-800">
            <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
        </svg>
    </a>
</div>

<!-- Banner -->
<div class="relative w-full h-64 bg-cover bg-center" style="background-image: url('1.png');">
    <div class="absolute inset-0 bg-black opacity-50"></div>
    <div class="relative z-10 flex flex-col text-center items-center justify-center h-full">
        <h1 class="text-4xl font-light merriweather-light-italic">Mr. Tailor</h1>
        <p class="text-lg mt-4">A white pure by the light of the moon qui</p>
    </div>
</div>

<!-- Content -->
<div class="container mx-auto py-10 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
    <?php foreach ($items as $item): ?>
        <div class="bg-transparent p-4">
            <div class="relative overflow-hidden rounded-lg shadow-lg group">
                <img src="<?php echo htmlspecialchars($item['image-cover']); ?>" 
                     alt="<?php echo htmlspecialchars($item['title']); ?>" 
                     class="w-full h-64 object-cover rounded-lg group-hover:opacity-75 cursor-zoom-in" 
                     onclick="showOverlay(this.src)"
                     ondragstart="return false;">
                <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-50 flex justify-center items-center transition duration-300">
                    <span class="text-white text-lg opacity-0 group-hover:opacity-100">View large image</span>
                </div>
            </div>
            <h2 class="mt-4 text-2xl font-semibold"><?php echo htmlspecialchars($item['title']); ?></h2>
            <p class="mt-2"><?php echo htmlspecialchars($item['description']); ?></p>
            <p class="mt-2 text-sm text-green-200"><?php echo htmlspecialchars($item['price']); ?></p>
            <a href="<?php echo htmlspecialchars($item['link']); ?>" target="_blank" class="mt-4 inline-block px-6 py-2 bg-white text-black rounded-full transition duration-300 hover:bg-gray-300">Buy this stone</a>
        </div>
    <?php endforeach; ?>
</div>

<div id="image-overlay" onclick="hideOverlay()">
    <img id="overlay-image" src="" alt="Image agrandie" ondragstart="return false;">
</div>

<script>
    // Animation de l'icône hamburger
    setTimeout(() => {
        document.getElementById('hamburger-icon').classList.remove('opacity-0');
    }, 1000);

    // Fonctions pour l'overlay d'image
    function showOverlay(src) {
        document.getElementById('overlay-image').src = src;
        document.getElementById('image-overlay').style.display = 'flex';
    }

    function hideOverlay() {
        document.getElementById('image-overlay').style.display = 'none';
    }

    // Empêcher le glisser-déposer sur toutes les images
    document.addEventListener('dragstart', function(event) {
        if (event.target.tagName.toLowerCase() === 'img') {
            event.preventDefault();
        }
    });
</script>

</body>
</html>