<?php
session_start();
include 'db.php';
include 'header-mobile.php';

if (!isset($_SESSION['resident_id'])) {
  header('Location: login.php');
  exit;
}

$resident_id = $_SESSION['resident_id'];
$stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$resident = $stmt->get_result()->fetch_assoc();

$is_premium = false;
$subscription = null;

if (mysqli_num_rows(mysqli_query($conn, "SHOW TABLES LIKE 'premium_subscriptions'")) > 0) {
    $premium_stmt = $conn->prepare("SELECT * FROM premium_subscriptions WHERE resident_id = ? AND status = 'active' AND expires_at > NOW()");
    $premium_stmt->bind_param("i", $resident_id);
    $premium_stmt->execute();
    $premium_result = $premium_stmt->get_result();
    $is_premium = $premium_result->num_rows > 0;
    $subscription = $premium_result->fetch_assoc();
}

$success_message = '';
$error_message = '';

if (isset($_POST['action'])) {
  if ($_POST['action'] == 'update_profile') {
      $first_name = trim($_POST['first_name']);
      $last_name = trim($_POST['last_name']);
      $email = trim($_POST['email']);
      $address = trim($_POST['address']);
      
      if (empty($first_name) || empty($last_name) || empty($email)) {
          $error_message = 'Tous les champs obligatoires doivent être remplis.';
      } else {
          $update_stmt = $conn->prepare("UPDATE residents SET first_name = ?, last_name = ?, email = ?, address = ? WHERE id = ?");
          $update_stmt->bind_param("ssssi", $first_name, $last_name, $email, $address, $resident_id);
          
          if ($update_stmt->execute()) {
              $success_message = 'Profil mis à jour avec succès !';
              $stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
              $stmt->bind_param("i", $resident_id);
              $stmt->execute();
              $resident = $stmt->get_result()->fetch_assoc();
          } else {
              $error_message = 'Erreur lors de la mise à jour du profil.';
          }
      }
  }

  if ($_POST['action'] == 'change_password') {
      $current_password = $_POST['current_password'];
      $new_password = $_POST['new_password'];
      $confirm_password = $_POST['confirm_password'];
      
      if (password_verify($current_password, $resident['password'])) {
          if ($new_password === $confirm_password && strlen($new_password) >= 6) {
              $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
              $pwd_stmt = $conn->prepare("UPDATE residents SET password = ? WHERE id = ?");
              $pwd_stmt->bind_param("si", $hashed_password, $resident_id);
              
              if ($pwd_stmt->execute()) {
                  $success_message = 'Mot de passe modifié avec succès !';
              } else {
                  $error_message = 'Erreur lors de la modification du mot de passe.';
              }
          } else {
              $error_message = 'Le nouveau mot de passe doit contenir au moins 6 caractères et les mots de passe doivent correspondre.';
          }
      } else {
          $error_message = 'Mot de passe actuel incorrect.';
      }
  }
}

$address = htmlspecialchars($resident['address']);
if (strlen($address) > 25) {
    $address = substr($address, 0, 22) . '...';
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Paramètres - Vert Chasseur</title>
  <link rel="icon" type="image/png" href="logo_new.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://js.stripe.com/v3/"></script>
  <script>
      tailwind.config = {
          darkMode: 'class',
          theme: {
              extend: {}
          }
      }
  </script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
<style>
   @media (min-width: 768px) {
       body {
           background-image: url('font-homepage.png');
           background-size: cover;
           background-position: center;
           background-attachment: fixed;
           background-repeat: no-repeat;
       }
   }
   
   @media (max-width: 767px) {
       body {
           background-color: #ffffff !important;
           background-image: none !important;
       }
       .dark body {
           background-color: #000000 !important;
           background-image: none !important;
       }
   }

   body {
       font-family: 'Poppins', sans-serif;
       letter-spacing: -0.01em;
   }

   .txt-chasseur {
       font-family: "Princess Sofia", serif;
       font-weight: 400;
   }

   .tabs {
       display: flex;
       gap: 4px;
       margin-bottom: 32px;
       background: rgba(0, 0, 0, 0.05);
       padding: 4px;
       border-radius: 12px;
       flex-wrap: wrap;
   }

   .dark .tabs {
       background: rgba(255, 255, 255, 0.05);
   }

   .tab-btn {
       flex: 1;
       min-width: 80px;
       padding: 12px 16px;
       background: transparent;
       border: none;
       border-radius: 8px;
       color: rgba(0, 0, 0, 0.7);
       font-size: 16px;
       font-weight: 500;
       cursor: pointer;
       transition: all 0.2s ease;
   }

   .dark .tab-btn {
       color: rgba(255, 255, 255, 0.7);
   }

   .tab-btn.active {
       background: rgba(0, 0, 0, 0.15);
       color: #000000;
   }

   .dark .tab-btn.active {
       background: rgba(255, 255, 255, 0.15);
       color: #ffffff;
   }

   .tab-btn:hover:not(.active) {
       background: rgba(0, 0, 0, 0.08);
       color: rgba(0, 0, 0, 0.9);
   }

   .dark .tab-btn:hover:not(.active) {
       background: rgba(255, 255, 255, 0.08);
       color: rgba(255, 255, 255, 0.9);
   }

   .tab-content {
       display: none;
   }

   .tab-content.active {
       display: block;
   }

   .form-group {
       margin-bottom: 24px;
   }

   .form-label {
       display: block;
       font-size: 14px;
       font-weight: 500;
       color: rgba(0, 0, 0, 0.9);
       margin-bottom: 8px;
   }

   .dark .form-label {
       color: rgba(255, 255, 255, 0.9);
   }

   .form-input {
       width: 100%;
       padding: 16px;
       background: rgba(0, 0, 0, 0.05);
       border: 1px solid rgba(0, 0, 0, 0.1);
       border-radius: 12px;
       color: #000000;
       font-size: 16px;
       transition: all 0.2s ease;
   }

   .dark .form-input {
       background: rgba(255, 255, 255, 0.1);
       border: 1px solid rgba(255, 255, 255, 0.2);
       color: #ffffff;
   }

   .form-input::placeholder {
       color: rgba(0, 0, 0, 0.4);
   }

   .dark .form-input::placeholder {
       color: rgba(255, 255, 255, 0.5);
   }

   .form-input:focus {
       outline: none;
       border-color: #16a34a;
       background: rgba(0, 0, 0, 0.08);
   }

   .dark .form-input:focus {
       background: rgba(255, 255, 255, 0.15);
   }

   .form-textarea {
       resize: vertical;
       min-height: 100px;
   }

   .btn-primary {
       width: 100%;
       padding: 16px;
       background: #16a34a;
       border: none;
       border-radius: 12px;
       color: #ffffff;
       font-size: 16px;
       font-weight: 600;
       cursor: pointer;
       transition: background 0.2s ease;
   }

   .btn-primary:hover {
       background: #15803d;
   }

   .btn-secondary {
       width: 100%;
       padding: 16px;
       background: #6b7280;
       border: none;
       border-radius: 12px;
       color: #ffffff;
       font-size: 16px;
       font-weight: 600;
       cursor: pointer;
       transition: background 0.2s ease;
       margin-bottom: 12px;
   }

   .btn-secondary:hover {
       background: #4b5563;
   }

   .btn-danger {
       background: #dc2626;
       padding: 12px 20px;
       border: none;
       border-radius: 8px;
       color: #ffffff;
       font-size: 14px;
       font-weight: 500;
       cursor: pointer;
       transition: background 0.2s ease;
       margin-right: 12px;
       margin-bottom: 8px;
       display: inline-flex;
       align-items: center;
       gap: 8px;
   }

   .btn-danger:hover {
       background: #b91c1c;
   }

   .alert {
       padding: 16px;
       border-radius: 12px;
       margin-bottom: 24px;
       font-size: 14px;
       font-weight: 500;
   }

   .alert-success {
       background: rgba(34, 197, 94, 0.1);
       border: 1px solid rgba(34, 197, 94, 0.3);
       color: #15803d;
   }

   .dark .alert-success {
       color: #4ade80;
   }

   .alert-error {
       background: rgba(239, 68, 68, 0.1);
       border: 1px solid rgba(239, 68, 68, 0.3);
       color: #dc2626;
   }

   .dark .alert-error {
       color: #f87171;
   }

   .info-card {
       background: rgba(0, 0, 0, 0.03);
       border: 1px solid rgba(0, 0, 0, 0.1);
       border-radius: 16px;
       padding: 24px;
       margin-bottom: 24px;
   }

   .dark .info-card {
       background: rgba(255, 255, 255, 0.05);
       border: 1px solid rgba(255, 255, 255, 0.1);
   }

   .info-card h3 {
       font-size: 20px;
       font-weight: 600;
       color: #000000;
       margin-bottom: 16px;
   }

   .dark .info-card h3 {
       color: #ffffff;
   }

   .info-item {
       display: flex;
       justify-content: space-between;
       align-items: center;
       padding: 12px 0;
       border-bottom: 1px solid rgba(0, 0, 0, 0.1);
   }

   .dark .info-item {
       border-bottom: 1px solid rgba(255, 255, 255, 0.1);
   }

   .info-item:last-child {
       border-bottom: none;
   }

   .info-label {
       font-size: 14px;
       font-weight: 500;
       color: rgba(0, 0, 0, 0.7);
   }

   .dark .info-label {
       color: rgba(255, 255, 255, 0.7);
   }

   .info-value {
       font-size: 14px;
       color: #000000;
       font-weight: 500;
   }

   .dark .info-value {
       color: #ffffff;
   }

   .danger-zone {
       background: rgba(239, 68, 68, 0.1);
       border: 1px solid rgba(239, 68, 68, 0.3);
       border-radius: 16px;
       padding: 24px;
   }

   .danger-zone h3 {
       font-size: 20px;
       font-weight: 600;
       color: #dc2626;
       margin-bottom: 8px;
   }

   .dark .danger-zone h3 {
       color: #f87171;
   }

   .danger-zone p {
       color: rgba(220, 38, 38, 0.8);
       font-size: 14px;
       margin-bottom: 20px;
   }

   .dark .danger-zone p {
       color: rgba(248, 113, 113, 0.8);
   }

   .wallet-card {
       background: linear-gradient(135deg, #059669 0%, #047857 100%);
       border-radius: 24px;
       padding: 32px;
       position: relative;
       overflow: hidden;
       margin-bottom: 32px;
       max-width: 400px;
       margin-left: auto;
       margin-right: auto;
   }

   .wallet-card::before {
       content: '';
       position: absolute;
       top: -50px;
       right: -50px;
       width: 120px;
       height: 120px;
       background: rgba(255, 255, 255, 0.1);
       border-radius: 50%;
   }

   .wallet-badge {
       position: absolute;
       top: 16px;
       right: 16px;
       padding: 6px 12px;
       border-radius: 20px;
       font-size: 11px;
       font-weight: 700;
       text-transform: uppercase;
       letter-spacing: 0.5px;
   }

   .wallet-badge-green {
       background: #22c55e;
       color: #ffffff;
   }

   .wallet-badge-gold {
       background: linear-gradient(45deg, #fbbf24, #f59e0b);
       color: #ffffff;
   }

   .wallet-content {
       position: relative;
       z-index: 2;
       display: flex;
       flex-direction: column;
       height: 280px;
       color: #ffffff;
   }

   .wallet-header {
       margin-bottom: 24px;
   }

   .wallet-name {
       font-size: 24px;
       font-weight: 700;
       line-height: 1.2;
       margin-bottom: 4px;
   }

   .wallet-title {
       font-size: 16px;
       opacity: 0.9;
       font-weight: 500;
   }

   .wallet-barcode {
       flex: 1;
       display: flex;
       align-items: center;
       justify-content: center;
       margin: 24px 0;
   }

   .barcode-container {
       background: #ffffff;
       padding: 16px;
       border-radius: 12px;
   }

   .barcode-img {
       height: 60px;
       width: auto;
       object-fit: contain;
   }

   .wallet-footer {
       display: flex;
       justify-content: space-between;
       align-items: end;
       margin-top: 24px;
   }

   .wallet-id {
       font-size: 12px;
       opacity: 0.8;
       font-weight: 500;
   }

   .wallet-address {
       font-size: 12px;
       opacity: 0.9;
       font-weight: 500;
       text-align: right;
       max-width: 150px;
       line-height: 1.3;
   }

   .pricing-card {
       background: rgba(0, 0, 0, 0.03);
       border: 1px solid rgba(0, 0, 0, 0.1);
       border-radius: 16px;
       padding: 24px;
       text-align: center;
       margin-bottom: 24px;
   }

   .dark .pricing-card {
       background: rgba(255, 255, 255, 0.05);
       border: 1px solid rgba(255, 255, 255, 0.1);
   }

   .price {
       font-size: 48px;
       font-weight: 700;
       color: #16a34a;
       margin-bottom: 8px;
   }

   .price-period {
       color: #666;
       font-size: 16px;
       margin-bottom: 24px;
   }

   .dark .price-period {
       color: #999;
   }

   .benefits {
       text-align: left;
       margin: 24px 0;
   }

   .benefit-item {
       display: flex;
       align-items: center;
       gap: 12px;
       margin-bottom: 16px;
       color: #333;
   }

   .dark .benefit-item {
       color: #fff;
   }

   .benefit-icon {
       width: 20px;
       height: 20px;
       color: #16a34a;
       flex-shrink: 0;
   }

   #payment-request-button {
       margin-top: 16px;
   }

   @media (max-width: 640px) {
       .wallet-card {
           padding: 24px;
           margin-bottom: 24px;
       }
       
       .wallet-content {
           height: 240px;
       }
       
       .wallet-name {
           font-size: 20px;
       }
   }
</style>
</head>

<body class="bg-white dark:bg-black transition-colors duration-300">
  <script>
      if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
          document.documentElement.classList.add('dark');
      } else {
          document.documentElement.classList.remove('dark');
      }
  </script>

<main class="min-h-screen px-4 py-8 md:py-16">
    <div class="max-w-4xl mx-auto">
        <div class="flex items-center justify-between mb-8">
            <div>
                <h1 class="text-3xl md:text-4xl font-light text-stone-800 dark:text-white mb-2 tracking-tight">Paramètres</h1>
                <p class="text-stone-600 dark:text-stone-400">Personnalise ton expérience dans l'application</p>
            </div>
            <a href="index.php" class="flex items-center gap-2 px-4 py-2 bg-stone-100 dark:bg-stone-800 hover:bg-stone-200 dark:hover:bg-stone-700 rounded-lg transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Retour
            </a>
        </div>

        <div class="tabs">
            <button class="tab-btn active" onclick="switchTab(event, 'wallet')">Carte Membre</button>
            <button class="tab-btn" onclick="switchTab(event, 'profile')">Profil</button>
            <button class="tab-btn" onclick="switchTab(event, 'security')">Sécurité</button>
            <button class="tab-btn" onclick="switchTab(event, 'account')">Compte</button>
        </div>

        <?php if ($success_message): ?>
        <div class="alert alert-success">
            <?= htmlspecialchars($success_message) ?>
        </div>
        <?php endif; ?>

        <?php if ($error_message): ?>
        <div class="alert alert-error">
            <?= htmlspecialchars($error_message) ?>
        </div>
        <?php endif; ?>

        <div id="wallet" class="tab-content active">
            <?php if ($is_premium): ?>
            <div class="wallet-card">
                <div class="wallet-badge wallet-badge-gold">
                    PREMIUM
                </div>
                
                <div class="wallet-content">
                    <div class="wallet-header">
                        <h3 class="wallet-name"><?= htmlspecialchars($resident['first_name'] . ' ' . $resident['last_name']) ?></h3>
                        <p class="wallet-title">Membre Premium Vert Chasseur</p>
                    </div>
                    
                    <div class="wallet-barcode">
                        <div class="barcode-container">
                            <img src="https://barcode.tec-it.com/barcode.ashx?data=<?= urlencode($resident['id']) ?>&code=Code128&translate-esc=true&width=280&height=80&color=000000" 
                                 alt="Code-barres" 
                                 class="barcode-img">
                        </div>
                    </div>
                    
                    <div class="wallet-footer">
                        <div class="wallet-id">ID: <?= $resident['id'] ?></div>
                        <div class="wallet-address"><?= $address ?></div>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div class="pricing-card">
                <div class="price">1,99€</div>
                <div class="price-period">par mois</div>
                
                <div class="benefits">
                    <div class="benefit-item">
                        <svg class="benefit-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>10% de réduction chez tous les partenaires</span>
                    </div>
                    <div class="benefit-item">
                        <svg class="benefit-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>Accès aux offres exclusives</span>
                    </div>
                    <div class="benefit-item">
                        <svg class="benefit-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>Carte membre digitale</span>
                    </div>
                    <div class="benefit-item">
                        <svg class="benefit-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>Support prioritaire</span>
                    </div>
                </div>

                <button onclick="openPaymentModal()" class="btn-primary">
                    S'abonner maintenant
                </button>
            </div>
            <?php endif; ?>
            
            <?php if ($is_premium): ?>
            <div class="info-card">
                <h3>Abonnement Premium Actif</h3>
                <div class="info-item">
                    <span class="info-label">Statut</span>
                    <span class="info-value text-green-600">Premium</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Renouvellement</span>
                    <span class="info-value"><?= date('d/m/Y', strtotime($subscription['expires_at'])) ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Prix</span>
                    <span class="info-value">1,99€/mois</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Gestion</span>
                    <button onclick="cancelSubscription()" class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm rounded-lg transition-colors">
                        Annuler l'abonnement
                    </button>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="info-card">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-black dark:text-white">Comment utiliser ta carte ?</h3>
                </div>
                <div class="space-y-3 text-sm text-black dark:text-white">
                    <div class="flex items-start space-x-3">
                        <span class="flex-shrink-0 w-6 h-6 bg-green-100 dark:bg-green-800 text-green-700 dark:text-green-300 rounded-full flex items-center justify-center text-xs font-bold">1</span>
                        <p>Présente ta carte chez les commerçants partenaires de Vert Chasseur</p>
                    </div>
                    <div class="flex items-start space-x-3">
                        <span class="flex-shrink-0 w-6 h-6 bg-green-100 dark:bg-green-800 text-green-700 dark:text-green-300 rounded-full flex items-center justify-center text-xs font-bold">2</span>
                        <p>Montre le code-barres au commerçant pour scanner ta carte</p>
                    </div>
                    <div class="flex items-start space-x-3">
                        <span class="flex-shrink-0 w-6 h-6 bg-green-100 dark:bg-green-800 text-green-700 dark:text-green-300 rounded-full flex items-center justify-center text-xs font-bold">3</span>
                        <p><?= $is_premium ? 'Profite des réductions de 10% chez nos partenaires' : 'Souscris au premium pour profiter des réductions' ?></p>
                    </div>
                </div>
                
                <div class="mt-6 pt-4 border-t border-stone-200 dark:border-stone-700">
                    <h4 class="font-semibold text-black dark:text-white mb-3">Tes avantages membre :</h4>
                    <div class="space-y-2">
                        <div class="flex items-center space-x-2">
                            <span class="w-2 h-2 <?= $is_premium ? 'bg-green-500' : 'bg-gray-400' ?> rounded-full"></span>
                            <span class="text-sm text-black dark:text-white">Réductions de 10% chez nos partenaires <?= !$is_premium ? '(Premium requis)' : '' ?></span>
                        </div>
                        <div class="flex items-center space-x-2">
                            <span class="w-2 h-2 bg-green-500 rounded-full"></span>
                            <span class="text-sm text-black dark:text-white">Accès à tous les services du quartier</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="profile" class="tab-content">
            <form method="POST">
                <input type="hidden" name="action" value="update_profile">
                
                <div class="form-group">
                    <label class="form-label">Prénom *</label>
                    <input type="text" name="first_name" value="<?= htmlspecialchars($resident['first_name']) ?>" required class="form-input">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Nom *</label>
                    <input type="text" name="last_name" value="<?= htmlspecialchars($resident['last_name']) ?>" required class="form-input">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Email *</label>
                    <input type="email" name="email" value="<?= htmlspecialchars($resident['email']) ?>" required class="form-input">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Adresse</label>
                    <textarea name="address" rows="3" class="form-input form-textarea"><?= htmlspecialchars($resident['address']) ?></textarea>
                </div>
                
                <button type="submit" class="btn-primary">Mettre à jour le profil</button>
            </form>
        </div>

        <div id="security" class="tab-content">
            <form method="POST">
                <input type="hidden" name="action" value="change_password">
                
                <div class="form-group">
                    <label class="form-label">Mot de passe actuel *</label>
                    <input type="password" name="current_password" required class="form-input">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Nouveau mot de passe *</label>
                    <input type="password" name="new_password" required minlength="6" class="form-input">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Confirmer le nouveau mot de passe *</label>
                    <input type="password" name="confirm_password" required minlength="6" class="form-input">
                </div>
                
                <button type="submit" class="btn-primary">Changer le mot de passe</button>
            </form>
        </div>

        <div id="account" class="tab-content">               
            <div class="info-card">
                <h3>Informations du compte</h3>
                <div class="info-item">
                    <span class="info-label">ID</span>
                    <span class="info-value"><?= $resident['id'] ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Statut</span>
                    <span class="info-value"><?= $is_premium ? 'Membre Premium' : 'Membre Gratuit' ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Membre depuis</span>
                    <span class="info-value"><?= date('d/m/Y à H:i', strtotime($resident['created_at'])) ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Dernière connexion</span>
                    <span class="info-value"><?= isset($resident['last_login']) ? date('d/m/Y à H:i', strtotime($resident['last_login'])) : 'Jamais' ?></span>
                </div>
            </div>
            
            <div class="danger-zone">
                <h3>Zone de danger</h3>
                <p>Actions irréversibles concernant ton compte.</p>
                
                <a href="/logout" onclick="return confirm('Es-tu sûr de vouloir te déconnecter ?')" class="btn-danger">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                    </svg>
                    Se déconnecter
                </a>
                <a href="delete-account.php" class="btn-danger">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                         <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                   </svg>
                   Supprimer mon compte
               </a>
           </div>
       </div>
   </div>
</main>

<script>
function switchTab(event, tabName) {
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabButtons.forEach(btn => btn.classList.remove('active'));
    tabContents.forEach(content => content.classList.remove('active'));
    
    event.target.classList.add('active');
    document.getElementById(tabName).classList.add('active');
}

function openPaymentModal() {
    const modal = document.createElement('div');
    modal.style.cssText = `
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        background: white;
        z-index: 10000;
        opacity: 0;
        transition: opacity 0.3s ease;
    `;
    
    const iframe = document.createElement('iframe');
    const timestamp = new Date().getTime();
    iframe.src = `iframe-pay.php?resident_id=<?= $resident_id ?>&t=${timestamp}`;
    iframe.style.cssText = `
        width: 100%;
        height: 100%;
        border: none;
        background: white;
        transform: scale(0.95);
        transition: transform 0.3s ease;
    `;
    
    modal.appendChild(iframe);
    document.body.appendChild(modal);
    
    requestAnimationFrame(() => {
        modal.style.opacity = '1';
        iframe.style.transform = 'scale(1)';
    });
    
    const messageHandler = function(event) {
        if (event.data.success) {
            modal.style.opacity = '0';
            iframe.style.transform = 'scale(0.95)';
            
            setTimeout(() => {
                document.body.removeChild(modal);
                window.removeEventListener('message', messageHandler);
                window.location.reload();
            }, 300);
        }
    };
    
    window.addEventListener('message', messageHandler);
}

async function cancelSubscription() {
    if (!confirm('Es-tu sûr de vouloir annuler ton abonnement premium ? Tu perdras tous les avantages à la fin de la période de facturation.')) {
        return;
    }

    try {
        const response = await fetch('cancel-subscription.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            }
        });

        const result = await response.json();

        if (result.success) {
            alert('Abonnement annulé avec succès. Tu conserves tes avantages jusqu\'à la fin de la période de facturation.');
            window.location.reload();
        } else {
            alert('Erreur lors de l\'annulation: ' + result.error);
        }
    } catch (error) {
        alert('Erreur lors de l\'annulation de l\'abonnement');
    }
}
</script>

document.addEventListener('DOMContentLoaded', function() {
    <?php if (!$is_premium): ?>
    new StripeNativePay();
    <?php endif; ?>
});
</script>

</body>
</html>