<?php
session_start();
require_once 'db.php';

if(!isset($_GET['token']) || empty($_GET['token'])) {
    die('Token manquant');
}

$token = $_GET['token'];

$sql = "SELECT dt.*, u.email FROM account_deletion_tokens dt 
        JOIN users u ON dt.user_id = u.id 
        WHERE dt.token = ? AND dt.expires_at > NOW()";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();
$deletion_request = $result->fetch_assoc();

if(!$deletion_request) {
    die('Token invalide ou expiré');
}

if(isset($_POST['confirm_delete'])) {
    $user_id = $deletion_request['user_id'];
    
    $conn->begin_transaction();
    
    try {
        $sql = "DELETE FROM linked_players WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM loterie_participations WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM transactions WHERE user_id = ? OR destinataire_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ii", $user_id, $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM courriers WHERE destinataire_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM casier_judiciaire WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM comptes_bancaires WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM identites WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM account_deletion_tokens WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "DELETE FROM users WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $conn->commit();
        
        session_destroy();
        header("Location: account_deleted.php");
        exit();
        
    } catch (Exception $e) {
        $conn->rollback();
        $error = "Erreur lors de la suppression : " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suppression de compte - Peerkinton</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>body { font-family: 'Poppins', sans-serif; }</style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8">
            <div class="text-center">
                <img src="logo.png" alt="Peerkinton" class="mx-auto h-12 mb-6">
                <h2 class="text-3xl font-bold text-gray-900">Suppression définitive</h2>
                <p class="mt-2 text-gray-600">Compte : <?php echo htmlspecialchars($deletion_request['email']); ?></p>
            </div>
            
            <?php if(isset($error)): ?>
                <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <div class="bg-white shadow rounded-lg p-6">
                <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">Attention !</h3>
                            <div class="mt-2 text-sm text-red-700">
                                <p>Cette action supprimera définitivement toutes tes données et ne peut pas être annulée.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <form method="POST" class="space-y-4">
                    <div class="flex items-center">
                        <input type="checkbox" id="confirm" required class="h-4 w-4 text-red-600 border-gray-300 rounded">
                        <label for="confirm" class="ml-2 text-sm text-gray-900">
                            Je comprends que cette action est irréversible
                        </label>
                    </div>
                    
                    <button type="submit" name="confirm_delete" 
                            class="w-full bg-red-600 text-white py-3 px-4 rounded-lg hover:bg-red-700 font-medium">
                        SUPPRIMER DÉFINITIVEMENT MON COMPTE
                    </button>
                </form>
                
                <div class="mt-4 text-center">
                    <a href="https://peerkinton.com/dashboard.php" class="text-sm text-gray-500 hover:text-gray-700">
                        Annuler et retourner au dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>