<?php
// Fonctions pour le cryptage/décryptage des numéros de loterie

function crypterNumeros($numeros, $cle) {
    // Utiliser base64 + simple décalage pour éviter les problèmes d'encoding
    $data = $numeros . '|' . $cle;
    $encrypted = base64_encode($data);
    
    // Ajouter un décalage simple pour plus de sécurité
    $shifted = '';
    for($i = 0; $i < strlen($encrypted); $i++) {
        $shifted .= chr((ord($encrypted[$i]) + 3) % 256);
    }
    
    return base64_encode($shifted);
}

function decrypterNumeros($numeros_cryptes, $cle) {
    try {
        // Décoder le base64 externe
        $shifted = base64_decode($numeros_cryptes);
        
        // Annuler le décalage
        $encrypted = '';
        for($i = 0; $i < strlen($shifted); $i++) {
            $encrypted .= chr((ord($shifted[$i]) - 3 + 256) % 256);
        }
        
        // Décoder et vérifier la clé
        $data = base64_decode($encrypted);
        $parts = explode('|', $data);
        
        if(count($parts) == 2 && $parts[1] == $cle) {
            return $parts[0]; // Retourner les numéros
        }
        
        return false;
    } catch(Exception $e) {
        return false;
    }
}

function genererNumerosAleatoires() {
    $nums = range(1, 10);
    shuffle($nums);
    $numeros = array_slice($nums, 0, 3);
    sort($numeros);
    return implode('-', $numeros);
}

function validerNumeros($numeros) {
    $nums = explode('-', $numeros);
    
    if(count($nums) != 3) {
        return false;
    }
    
    foreach($nums as $num) {
        $n = (int)$num;
        if($n < 1 || $n > 10) {
            return false;
        }
    }
    
    // Vérifier qu'ils sont tous différents
    if(count(array_unique($nums)) != 3) {
        return false;
    }
    
    return true;
}
?>