<?php
session_start();

if(isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

if(isset($_POST['login'])) {
    require_once 'db.php';
    
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    $sql = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        if(password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['email'] = $user['email'];
            
            header("Location: dashboard.php");
            exit();
        } else {
            $error = "Mot de passe incorrect";
        }
    } else {
        $error = "Email non trouvé";
    }
    
    $stmt->close();
    $conn->close();
}

if(isset($_POST['reset_password'])) {
    require_once 'db.php';
    
    $email = $_POST['reset_email'];
    
    $sql = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $token = bin2hex(random_bytes(32));
        $expiry = date('Y-m-d H:i:s', strtotime('+1 hour'));
        
        $sql = "UPDATE users SET reset_token = ?, reset_expiry = ? WHERE email = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sss", $token, $expiry, $email);
        $stmt->execute();
        
        $reset_link = "http://" . $_SERVER['HTTP_HOST'] . "/reset_password.php?token=" . $token;
        
        $to = $email;
        $subject = "Réinitialisation de ton mot de passe Peerkinton";
        
        $message = "
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset='UTF-8'>
            <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        </head>
        <body style='margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, \"Helvetica Neue\", Arial, sans-serif;'>
            <table width='100%' cellpadding='0' cellspacing='0' style='background-color: #ffffff;'>
                <tr>
                    <td align='center' style='padding: 40px 20px;'>
                        <table width='100%' style='max-width: 600px;' cellpadding='0' cellspacing='0'>
                            <tr>
                                <td align='center' style='padding-bottom: 40px;'>
                                    <img src='http://" . $_SERVER['HTTP_HOST'] . "/logo.png' alt='Peerkinton' style='height: 32px;'>
                                </td>
                            </tr>
                            <tr>
                                <td style='padding: 0 20px;'>
                                    <h1 style='font-size: 24px; font-weight: 500; color: #000000; margin: 0 0 16px 0;'>Réinitialisation de mot de passe</h1>
                                    <p style='font-size: 16px; color: #666666; line-height: 24px; margin: 0 0 32px 0;'>
                                        Tu as demandé à réinitialiser ton mot de passe. Clique sur le bouton ci-dessous pour créer un nouveau mot de passe.
                                    </p>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tr>
                                            <td align='center' style='padding: 0 0 32px 0;'>
                                                <a href='" . $reset_link . "' style='display: inline-block; background-color: #000000; color: #ffffff; text-decoration: none; padding: 14px 32px; font-size: 14px; font-weight: 500; letter-spacing: 0.5px; text-transform: uppercase; border-radius: 4px;'>
                                                    Réinitialiser mon mot de passe
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                    <p style='font-size: 14px; color: #999999; line-height: 20px; margin: 0 0 8px 0;'>
                                        Si tu n'as pas demandé cette réinitialisation, tu peux ignorer cet email.
                                    </p>
                                    <p style='font-size: 14px; color: #999999; line-height: 20px; margin: 0;'>
                                        Ce lien expire dans 1 heure.
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style='padding: 40px 20px 0 20px; border-top: 1px solid #f0f0f0;'>
                                    <p style='font-size: 12px; color: #999999; text-align: center; margin: 0;'>
                                        © 2025 Peerkinton. Tous droits réservés.
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </body>
        </html>
        ";
        
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: Peerkinton <noreply@peerkinton.com>" . "\r\n";
        
        mail($to, $subject, $message, $headers);
        
        $success = "Un email de réinitialisation a été envoyé à ton adresse.";
    } else {
        $error = "Aucun compte associé à cet email.";
    }
    
    $stmt->close();
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Connexion</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white text-gray-900 min-h-screen flex items-center justify-center">
    <div class="w-full px-4 sm:px-6 py-8 sm:py-12">
        <div class="max-w-md mx-auto">
            <div class="mb-10 sm:mb-16 text-center">
                <img src="logo.png" alt="Peerkinton Logo" class="h-6 sm:h-8 mx-auto">
            </div>
            
            <div class="text-center mb-6 sm:mb-10">
                <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">Connexion</h1>
                <p class="text-gray-600 font-light">Connecte-toi pour accéder à ton compte Peerkinton.</p>
            </div>
            
            <div class="mb-6">
                <?php if(isset($error)): ?>
                    <div class="bg-red-50 text-red-800 px-4 py-3 rounded mb-4">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <?php if(isset($success)): ?>
                    <div class="bg-green-50 text-green-800 px-4 py-3 rounded mb-4">
                        <?php echo $success; ?>
                    </div>
                <?php endif; ?>
                
                <form action="" method="POST">
                    <div class="mb-4">
                        <input type="email" name="email" required placeholder="Email" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                    </div>
                    <div class="mb-4">
                        <input type="password" name="password" required placeholder="Mot de passe" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                    </div>
                    <div class="mb-6 text-right">
                        <button type="button" onclick="showResetModal()" class="text-sm text-gray-600 hover:text-black">
                            Mot de passe oublié ?
                        </button>
                    </div>
                    <button type="submit" name="login" class="w-full bg-black text-white px-6 py-3 font-medium text-sm uppercase tracking-wider rounded">
                        Se connecter
                    </button>
                </form>
            </div>
            
            <p class="text-gray-600 text-center mb-6">
                Tu n'as pas encore de compte? <a href="register.php" class="text-black font-medium">Inscris-toi ici</a>
            </p>
            
            <div class="text-center">
                <button onclick="showHelp()" class="bg-gray-100 text-gray-700 px-4 py-2 rounded-full text-sm font-medium hover:bg-gray-200 transition-colors">
                    <i class="fas fa-question-circle mr-2"></i>Aide
                </button>
            </div>
        </div>
    </div>
    
    <div id="helpModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg max-w-md w-full p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold">Aide à la connexion</h3>
                <button onclick="hideHelp()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="space-y-3 text-sm text-gray-600">
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Problème de connexion ?</h4>
                    <p>Vérifie que ton email et ton mot de passe sont corrects. Les mots de passe sont sensibles à la casse.</p>
                </div>
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Mot de passe oublié ?</h4>
                    <p>Clique sur "Mot de passe oublié ?" pour recevoir un lien de réinitialisation par email.</p>
                </div>
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Premier compte ?</h4>
                    <p>Clique sur "Inscris-toi ici" pour créer ton compte Peerkinton.</p>
                </div>
            </div>
            <div class="mt-6">
                <button onclick="hideHelp()" class="w-full bg-black text-white py-2 px-4 rounded font-medium">
                    Fermer
                </button>
            </div>
        </div>
    </div>

    <div id="resetModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg max-w-md w-full p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold">Réinitialiser ton mot de passe</h3>
                <button onclick="hideResetModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <p class="text-sm text-gray-600 mb-6">
                Entre ton adresse email et nous t'enverrons un lien pour réinitialiser ton mot de passe.
            </p>
            <form action="" method="POST">
                <div class="mb-6">
                    <input type="email" name="reset_email" required placeholder="Ton email" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                </div>
                <button type="submit" name="reset_password" class="w-full bg-black text-white py-3 px-4 rounded font-medium mb-3">
                    Envoyer le lien
                </button>
                <button type="button" onclick="hideResetModal()" class="w-full bg-gray-100 text-gray-700 py-3 px-4 rounded font-medium">
                    Annuler
                </button>
            </form>
        </div>
    </div>

    <script>
        function showHelp() {
            document.getElementById('helpModal').classList.remove('hidden');
            document.getElementById('helpModal').classList.add('flex');
        }

        function hideHelp() {
            document.getElementById('helpModal').classList.add('hidden');
            document.getElementById('helpModal').classList.remove('flex');
        }

        function showResetModal() {
            document.getElementById('resetModal').classList.remove('hidden');
            document.getElementById('resetModal').classList.add('flex');
        }

        function hideResetModal() {
            document.getElementById('resetModal').classList.add('hidden');
            document.getElementById('resetModal').classList.remove('flex');
        }

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                hideHelp();
                hideResetModal();
            }
        });
    </script>
</body>
</html>