"use client";
import {
  useDatePicker
} from "./chunk-OLWPKOFU.mjs";

// src/date-picker.tsx
import { useMemo } from "react";
import { cloneElement, isValidElement } from "react";
import { forwardRef } from "@heroui/system";
import { Button } from "@heroui/button";
import { DateInput, TimeInput } from "@heroui/date-input";
import { FreeSoloPopover } from "@heroui/popover";
import { Calendar } from "@heroui/calendar";
import { AnimatePresence } from "framer-motion";
import { CalendarBoldIcon } from "@heroui/shared-icons";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var DatePicker = forwardRef(function DatePicker2(props, ref) {
  const { selectorButtonPlacement = "end", ...otherProps } = props;
  const {
    state,
    startContent,
    endContent,
    selectorIcon,
    showTimeField,
    disableAnimation,
    isCalendarHeaderExpanded,
    getDateInputProps,
    getPopoverProps,
    getTimeInputProps,
    getSelectorButtonProps,
    getSelectorIconProps,
    getCalendarProps,
    CalendarTopContent,
    CalendarBottomContent
  } = useDatePicker({ ...otherProps, ref });
  const selectorContent = isValidElement(selectorIcon) ? cloneElement(selectorIcon, getSelectorIconProps()) : /* @__PURE__ */ jsx(CalendarBoldIcon, { ...getSelectorIconProps() });
  const calendarBottomContent = useMemo(() => {
    if (isCalendarHeaderExpanded) return null;
    return showTimeField ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(TimeInput, { ...getTimeInputProps() }),
      CalendarBottomContent
    ] }) : CalendarBottomContent;
  }, [state, showTimeField, CalendarBottomContent, isCalendarHeaderExpanded]);
  const calendarTopContent = useMemo(() => {
    if (isCalendarHeaderExpanded) return null;
    return CalendarTopContent;
  }, [showTimeField, CalendarTopContent, isCalendarHeaderExpanded]);
  const popoverContent = state.isOpen ? /* @__PURE__ */ jsx(FreeSoloPopover, { ...getPopoverProps(), children: /* @__PURE__ */ jsx(
    Calendar,
    {
      ...getCalendarProps(),
      bottomContent: calendarBottomContent,
      topContent: calendarTopContent
    }
  ) }) : null;
  const dateInputProps = {
    ...getDateInputProps(),
    endContent: selectorButtonPlacement === "end" ? /* @__PURE__ */ jsx(Button, { ...getSelectorButtonProps(), children: endContent || selectorContent }) : endContent,
    startContent: selectorButtonPlacement === "start" ? /* @__PURE__ */ jsx(Button, { ...getSelectorButtonProps(), children: startContent || selectorContent }) : startContent
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(DateInput, { ...dateInputProps }),
    disableAnimation ? popoverContent : /* @__PURE__ */ jsx(AnimatePresence, { children: popoverContent })
  ] });
});
var date_picker_default = DatePicker;

export {
  date_picker_default
};
