"use client";
import {
  menu_item_default
} from "./chunk-LGPM6LBY.mjs";

// src/menu-section.tsx
import { menuSection } from "@heroui/theme";
import { useMenuSection } from "@react-aria/menu";
import { useMemo } from "react";
import { forwardRef } from "@heroui/system";
import { mergeProps } from "@react-aria/utils";
import { clsx } from "@heroui/shared-utils";
import { Divider } from "@heroui/divider";
import { jsx, jsxs } from "react/jsx-runtime";
var MenuSection = forwardRef(
  ({
    item,
    state,
    as,
    variant,
    color,
    disableAnimation,
    onAction,
    closeOnSelect,
    className,
    classNames,
    showDivider = false,
    hideSelectedIcon,
    dividerProps = {},
    itemClasses,
    // removed title from props to avoid browsers showing a tooltip on hover
    // the title props is already inside the rendered prop
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    title,
    ...otherProps
  }, _) => {
    const Component = as || "li";
    const slots = useMemo(() => menuSection(), []);
    const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
    const dividerStyles = clsx(classNames == null ? void 0 : classNames.divider, dividerProps == null ? void 0 : dividerProps.className);
    const { itemProps, headingProps, groupProps } = useMenuSection({
      heading: item.rendered,
      "aria-label": item["aria-label"]
    });
    return /* @__PURE__ */ jsxs(
      Component,
      {
        "data-slot": "base",
        ...mergeProps(itemProps, otherProps),
        className: slots.base({ class: baseStyles }),
        children: [
          item.rendered && /* @__PURE__ */ jsx(
            "span",
            {
              ...headingProps,
              className: slots.heading({ class: classNames == null ? void 0 : classNames.heading }),
              "data-slot": "heading",
              children: item.rendered
            }
          ),
          /* @__PURE__ */ jsxs(
            "ul",
            {
              ...groupProps,
              className: slots.group({ class: classNames == null ? void 0 : classNames.group }),
              "data-has-title": !!item.rendered,
              "data-slot": "group",
              children: [
                [...item.childNodes].map((node) => {
                  const { key: nodeKey, props: nodeProps } = node;
                  let menuItem = /* @__PURE__ */ jsx(
                    menu_item_default,
                    {
                      classNames: itemClasses,
                      closeOnSelect,
                      color,
                      disableAnimation,
                      hideSelectedIcon,
                      item: node,
                      state,
                      variant,
                      onAction,
                      ...nodeProps
                    },
                    nodeKey
                  );
                  if (node.wrapper) {
                    menuItem = node.wrapper(menuItem);
                  }
                  return menuItem;
                }),
                showDivider && /* @__PURE__ */ jsx(
                  Divider,
                  {
                    as: "li",
                    className: slots.divider({
                      class: dividerStyles
                    }),
                    ...dividerProps
                  }
                )
              ]
            }
          )
        ]
      }
    );
  }
);
MenuSection.displayName = "HeroUI.MenuSection";
var menu_section_default = MenuSection;

export {
  menu_section_default
};
