<?php
$menu_items = [
   ['text' => 'Pricing', 'url' => '/pricing'],
   ['text' => 'Statuts', 'url' => 'https://imators.systems/status=?ohmypanel'],
   ['text' => 'Need help?', 'url' => 'https://imators.com/support']
];
?>
<header id="header" class="fixed top-0 left-0 right-0 z-50 bg-white border-b border-gray-100 transition-opacity duration-300">
   <div class="px-6 md:px-12 py-4 flex items-center justify-between">
       
       <div class="flex items-center">
           <a href="/">
           <img src="logo.png" alt="Logo" class="h-8 animate-fade-in-left" style="animation-delay: 0ms;">
           </a>
       </div>
       <div class="md:hidden">
           <button id="hamburger" class="w-8 h-8 flex flex-col justify-center items-center space-y-1">
               <div class="w-6 h-0.5 bg-black transition-all duration-300"></div>
               <div class="w-6 h-0.5 bg-black transition-all duration-300"></div>
               <div class="w-6 h-0.5 bg-black transition-all duration-300"></div>
           </button>
       </div>
       <nav class="hidden md:flex items-center space-x-12">
           <?php foreach(array_reverse($menu_items) as $index => $item): ?>
               <a href="<?= $item['url'] ?>" class="text-black font-light tracking-wide hover:opacity-70 transition-opacity animate-fade-in-left" style="animation-delay: <?= ($index + 1) * 100 ?>ms;">
                   <?= $item['text'] ?>
               </a>
           <?php endforeach; ?>
       </nav>
   </div>
   <div id="mobile-menu" class="md:hidden fixed inset-0 bg-white transform translate-x-full transition-transform duration-300 ease-in-out">
       <div class="absolute top-6 right-6">
           <button id="close-menu" class="w-8 h-8 flex flex-col justify-center items-center">
               <div class="w-6 h-0.5 bg-black transform rotate-45 translate-y-0.5"></div>
               <div class="w-6 h-0.5 bg-black transform -rotate-45 -translate-y-0.5"></div>
           </button>
       </div>
       <div class="flex flex-col justify-center items-center h-full space-y-8">
           <?php foreach($menu_items as $item): ?>
               <a href="<?= $item['url'] ?>" class="text-4xl font-light text-black tracking-wide">
                   <?= $item['text'] ?>
               </a>
           <?php endforeach; ?>
       </div>
   </div>
</header>
<style>
@keyframes fadeInLeft {
   from {
       opacity: 0;
       transform: translateX(20px);
   }
   to {
       opacity: 1;
       transform: translateX(0);
   }
}
.animate-fade-in-left {
   animation: fadeInLeft 0.6s ease-out forwards;
   opacity: 0;
}
</style>
<script>
let lastScrollTop = 0;
const header = document.getElementById('header');

window.addEventListener('scroll', function() {
   const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
   
   if (scrollTop > lastScrollTop && scrollTop > 100) {
       header.style.opacity = '0';
   } else {
       header.style.opacity = '1';
   }
   
   lastScrollTop = scrollTop <= 0 ? 0 : scrollTop;
});

document.getElementById('hamburger').addEventListener('click', function() {
   const menu = document.getElementById('mobile-menu');
   menu.classList.remove('translate-x-full');
   menu.classList.add('translate-x-0');
});
document.getElementById('close-menu').addEventListener('click', function() {
   const menu = document.getElementById('mobile-menu');
   menu.classList.add('translate-x-full');
   menu.classList.remove('translate-x-0');
});
document.getElementById('mobile-menu').addEventListener('click', function(e) {
   if (e.target === this) {
       this.classList.add('translate-x-full');
       this.classList.remove('translate-x-0');
   }
});
</script>