<?php
define('ONESIGNAL_APP_ID', '8dedcd6d-d142-4d94-b3ac-1bac7c437c2b');
define('ONESIGNAL_REST_API_KEY', 'os_v2_app_rxw423orijgzjm5mdowhyq34foclm3pcoonuddu2hmdizjweqd7yq7iwsjufk2jihzjan4kpvt25zmov6fmrvcuwqygwlhpgihukuqi');
define('ONESIGNAL_URL', 'https://onesignal.com/api/v1/notifications');

function sendPushNotification($message, $platform = 'both') {
    require_once '../config/db_comm.php';
    
    $stmt = $pdo_comm->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute(['ios_enabled']);
    $ios_enabled = $stmt->fetchColumn();
    
    $stmt->execute(['android_enabled']);
    $android_enabled = $stmt->fetchColumn();
    
    $included_segments = [];
    
    if ($platform == 'both' || $platform == 'ios') {
        if ($ios_enabled) $included_segments[] = 'iOS Users';
    }
    
    if ($platform == 'both' || $platform == 'android') {
        if ($android_enabled) $included_segments[] = 'Android Users';
    }
    
    if (empty($included_segments)) {
        return false;
    }
    
    $fields = [
        'app_id' => ONESIGNAL_APP_ID,
        'included_segments' => $included_segments,
        'headings' => ['fr' => 'Vert Chasseur', 'en' => 'Vert Chasseur'],
        'contents' => ['fr' => $message, 'en' => $message]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, ONESIGNAL_URL);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . ONESIGNAL_REST_API_KEY
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}
?>