<?php
session_start();

if (!isset($_SESSION['resident_id'])) {
    header('Location: login.php');
    exit;
}

$plan = $_GET['plan'] ?? 'member';
$plan_names = [
    'member' => 'Membre Vert Chasseur',
    'premium' => 'Membre Vert+ Chasseur'
];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Abonnement confirmé - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .success-animation {
            animation: successPulse 2s ease-in-out infinite;
        }
        
        @keyframes successPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        .confetti {
            position: absolute;
            width: 10px;
            height: 10px;
            background: #16a34a;
            animation: confetti-fall 3s linear infinite;
        }
        
        .confetti:nth-child(odd) {
            background: #fbbf24;
            animation-delay: 0.5s;
        }
        
        .confetti:nth-child(even) {
            background: #3b82f6;
            animation-delay: 1s;
        }
        
        @keyframes confetti-fall {
            0% {
                transform: translateY(-100vh) rotate(0deg);
                opacity: 1;
            }
            100% {
                transform: translateY(100vh) rotate(360deg);
                opacity: 0;
            }
        }
    </style>
</head>

<body class="bg-gradient-to-br from-green-50 to-emerald-50 min-h-screen flex items-center justify-center p-4 relative overflow-hidden">
    <div class="confetti" style="left: 10%;"></div>
    <div class="confetti" style="left: 20%;"></div>
    <div class="confetti" style="left: 30%;"></div>
    <div class="confetti" style="left: 40%;"></div>
    <div class="confetti" style="left: 50%;"></div>
    <div class="confetti" style="left: 60%;"></div>
    <div class="confetti" style="left: 70%;"></div>
    <div class="confetti" style="left: 80%;"></div>
    <div class="confetti" style="left: 90%;"></div>

    <div class="max-w-md w-full bg-white rounded-2xl shadow-2xl p-8 text-center relative z-10">
        <div class="success-animation w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
            <svg class="w-10 h-10 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
        </div>
        
        <h1 class="text-3xl font-bold text-gray-900 mb-4">Félicitations !</h1>
        <p class="text-lg text-gray-600 mb-2">Tu es maintenant</p>
        <p class="text-xl font-semibold text-green-600 mb-6"><?= $plan_names[$plan] ?></p>
        
        <div class="bg-green-50 border border-green-200 rounded-xl p-4 mb-6">
            <div class="flex items-center justify-center mb-3">
                <svg class="w-5 h-5 text-green-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span class="font-medium text-green-800">Abonnement activé</span>
            </div>
            <p class="text-sm text-green-700">
                Ta carte membre est prête à être utilisée chez tous nos partenaires !
            </p>
        </div>
        
        <div class="space-y-3 mb-8">
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <span class="text-sm text-gray-600">Réductions</span>
                <span class="font-medium text-gray-900"><?= $plan === 'premium' ? '20%' : '10%' ?> chez les partenaires</span>
            </div>
            <?php if ($plan === 'premium'): ?>
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <span class="text-sm text-gray-600">Magazine</span>
                <span class="font-medium text-gray-900">Mensuel du quartier</span>
            </div>
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                <span class="text-sm text-gray-600">Livraison</span>
                <span class="font-medium text-gray-900">Service privé</span>
            </div>
            <?php endif; ?>
        </div>
        
        <a href="resident-dashboard.php" class="block w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-4 px-6 rounded-xl transition-colors duration-200 mb-4">
            Accéder à ma carte
        </a>
        
        <p class="text-xs text-gray-500">
            Tu recevras un email de confirmation avec les détails de ton abonnement.
        </p>
    </div>
    
    <script>
        setTimeout(() => {
            window.location.href = 'resident-dashboard.php';
        }, 5000);
    </script>
</body>
</html>