const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('ban')
        .setDescription('Ban un utilisateur')
        .addUserOption(option =>
            option.setName('utilisateur')
                .setDescription('Utilisateur à bannir')
                .setRequired(true)
        )
        .addStringOption(option =>
            option.setName('raison')
                .setDescription('Raison du bannissement')
                .setRequired(true)
        )
        .addIntegerOption(option =>
            option.setName('duree')
                .setDescription('Durée en jours pour supprimer les messages (0-7)')
                .setMinValue(0)
                .setMaxValue(7)
                .setRequired(false)
        ),
    
    async execute(interaction) {
        if (!interaction.member.permissions.has(PermissionFlagsBits.BanMembers)) {
            return interaction.reply({ 
                content: '❌ Tu n\'as pas la permission de bannir des utilisateurs!', 
                ephemeral: true 
            });
        }

        const targetUser = interaction.options.getUser('utilisateur');
        const reason = interaction.options.getString('raison');
        const deleteMessageDays = interaction.options.getInteger('duree') || 0;
        
        const targetMember = interaction.guild.members.cache.get(targetUser.id);

        if (targetMember) {
            if (targetMember.permissions.has(PermissionFlagsBits.Administrator)) {
                return interaction.reply({ 
                    content: '❌ Je ne peux pas bannir un administrateur!', 
                    ephemeral: true 
                });
            }

            if (targetMember.roles.highest.position >= interaction.member.roles.highest.position) {
                return interaction.reply({ 
                    content: '❌ Tu ne peux pas bannir quelqu\'un avec un rôle égal ou supérieur!', 
                    ephemeral: true 
                });
            }
        }

        try {
            const dmEmbed = new EmbedBuilder()
                .setColor('#FF0000')
                .setTitle('🔨 Tu as été banni')
                .setDescription(`Tu as été banni du serveur **${interaction.guild.name}**`)
                .addFields(
                    { name: '📝 Raison', value: reason, inline: false },
                    { name: '👤 Modérateur', value: `${interaction.user}`, inline: true },
                    { name: '📅 Date', value: `<t:${Math.floor(Date.now() / 1000)}:F>`, inline: true }
                )
                .setFooter({ text: 'Peerkinton • Modération' })
                .setTimestamp();

            try {
                await targetUser.send({ embeds: [dmEmbed] });
            } catch (error) {
                console.log('Impossible d\'envoyer le MP à l\'utilisateur banni');
            }

            await interaction.guild.members.ban(targetUser, {
                deleteMessageDays: deleteMessageDays,
                reason: `${reason} - Par ${interaction.user.tag}`
            });

            const successEmbed = new EmbedBuilder()
                .setColor('#00FF00')
                .setTitle('✅ Utilisateur banni')
                .setDescription(`**${targetUser.tag}** a été banni avec succès`)
                .addFields(
                    { name: '📝 Raison', value: reason, inline: false },
                    { name: '👤 Modérateur', value: `${interaction.user}`, inline: true },
                    { name: '🗑️ Messages supprimés', value: `${deleteMessageDays} jour(s)`, inline: true }
                )
                .setFooter({ text: 'Peerkinton • Modération' })
                .setTimestamp();

            await interaction.reply({ embeds: [successEmbed] });

        } catch (error) {
            console.error(error);
            await interaction.reply({ 
                content: '❌ Erreur lors du bannissement. Vérifie mes permissions!', 
                ephemeral: true 
            });
        }
    }
};