const { REST, Routes } = require('discord.js');
const fs = require('fs');

module.exports = {
    name: 'ready',
    once: true,
    async execute(client) {
        console.log(`Connecté en tant que ${client.user.tag}!`);
        
        const commands = [];
        const commandFiles = fs.readdirSync('./commands').filter(file => file.endsWith('.js'));

        for (const file of commandFiles) {
            const command = require(`../commands/${file}`);
            commands.push(command.data.toJSON());
        }

        const rest = new REST({ version: '10' }).setToken(client.config.token);

        try {
            console.log('Début du rafraîchissement des commandes slash (/)...');

            await rest.put(
                Routes.applicationCommands(client.config.clientId),
                { body: commands },
            );

            console.log('Commandes slash (/) rechargées avec succès!');
        } catch (error) {
            console.error(error);
        }

        client.user.setActivity('Peerkinton Server', { type: 'WATCHING' });
    },
};