<?php
session_start();

if(!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'db.php';

$user_id = $_SESSION['user_id'];

// Récupérer les infos utilisateur
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Récupérer l'entreprise de l'utilisateur
$sql = "SELECT e.* FROM entreprises e WHERE e.chef_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$mon_entreprise = $stmt->get_result()->fetch_assoc();

// Récupérer l'emploi actuel
$emploi_actuel = null;
$sql = "SELECT emp.*, ent.nom as nom_entreprise FROM employes emp 
        JOIN entreprises ent ON emp.entreprise_id = ent.id 
        WHERE emp.user_id = ? AND emp.statut = 'actif'";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$emploi_actuel = $stmt->get_result()->fetch_assoc();

// Traitement des actions
if(isset($_POST['action'])) {
    switch($_POST['action']) {
        case 'creer_entreprise':
            $nom = $_POST['nom'];
            $description = $_POST['description'];
            $secteur = $_POST['secteur'];
            $adresse = $_POST['adresse'];
            $telephone = $_POST['telephone'];
            $email = $_POST['email'];
            
            $id_bancaire = 'ENT-' . strtoupper(substr(md5(uniqid()), 0, 8));
            
            $sql = "INSERT INTO entreprises (nom, description, secteur, adresse, telephone, email, chef_id, id_bancaire_entreprise) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssssss", $nom, $description, $secteur, $adresse, $telephone, $email, $user_id, $id_bancaire);
            
            if($stmt->execute()) {
                $entreprise_id = $conn->insert_id;
                
                $sql = "INSERT INTO comptes_bancaires_entreprises (entreprise_id) VALUES (?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $entreprise_id);
                $stmt->execute();
                
                $sql = "UPDATE users SET chef_of_entreprise = 1 WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $user_id);
                $stmt->execute();
                
                header("Location: emplois.php?tab=gestion_entreprise&success=1");
                exit();
            }
            break;
            
       case 'verser_salaire':
    $employe_id = $_POST['employe_id'];
    
    $sql = "SELECT e.*, u.email, i.nom, i.prenom FROM employes e 
            JOIN users u ON e.user_id = u.id 
            LEFT JOIN identites i ON e.user_id = i.user_id 
            WHERE e.id = ? AND e.entreprise_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $employe_id, $mon_entreprise['id']);
    $stmt->execute();
    $employe = $stmt->get_result()->fetch_assoc();
    
    if($employe && $employe['statut'] == 'actif') {
        $sql = "SELECT solde FROM comptes_bancaires_entreprises WHERE entreprise_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $mon_entreprise['id']);
        $stmt->execute();
        $solde_entreprise = $stmt->get_result()->fetch_assoc()['solde'];
        
        if($solde_entreprise >= $employe['salaire']) {
            $sql = "UPDATE comptes_bancaires_entreprises SET solde = solde - ? WHERE entreprise_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("di", $employe['salaire'], $mon_entreprise['id']);
            $stmt->execute();
            
            $sql = "UPDATE comptes_bancaires SET solde = solde + ? WHERE user_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("di", $employe['salaire'], $employe['user_id']);
            $stmt->execute();
            
            $destinataire_nom = ($employe['nom'] && $employe['prenom']) ? $employe['nom'] . ' ' . $employe['prenom'] : $employe['email'];
            
            $sql = "INSERT INTO transactions (user_id, destinataire_id, type, montant, emetteur_nom, destinataire_nom) VALUES (?, ?, 'credit', ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iidss", $employe['user_id'], $employe['user_id'], $employe['salaire'], $mon_entreprise['nom'], $destinataire_nom);
            $stmt->execute();
            
            $sql = "UPDATE employes SET derniere_paie = CURDATE() WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $employe_id);
            $stmt->execute();
            
            header("Location: emplois.php?tab=gestion_entreprise&sous_tab=staff&success=salaire");
        } else {
            header("Location: emplois.php?tab=gestion_entreprise&sous_tab=staff&error=fonds");
        }
    }
    exit();
    break;

case 'verser_tous_salaires':
    $sql = "SELECT e.*, u.email, i.nom, i.prenom FROM employes e 
            JOIN users u ON e.user_id = u.id 
            LEFT JOIN identites i ON e.user_id = i.user_id 
            WHERE e.entreprise_id = ? AND e.statut = 'actif'";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $mon_entreprise['id']);
    $stmt->execute();
    $employes_actifs = $stmt->get_result();
    
    $total_salaires = 0;
    $employes_list = [];
    while($emp = $employes_actifs->fetch_assoc()) {
        $total_salaires += $emp['salaire'];
        $employes_list[] = $emp;
    }
    
    $sql = "SELECT solde FROM comptes_bancaires_entreprises WHERE entreprise_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $mon_entreprise['id']);
    $stmt->execute();
    $solde_entreprise = $stmt->get_result()->fetch_assoc()['solde'];
    
    if($solde_entreprise >= $total_salaires && count($employes_list) > 0) {
        foreach($employes_list as $employe) {
            $sql = "UPDATE comptes_bancaires SET solde = solde + ? WHERE user_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("di", $employe['salaire'], $employe['user_id']);
            $stmt->execute();
            
            $destinataire_nom = ($employe['nom'] && $employe['prenom']) ? $employe['nom'] . ' ' . $employe['prenom'] : $employe['email'];
            
            $sql = "INSERT INTO transactions (user_id, destinataire_id, type, montant, emetteur_nom, destinataire_nom) VALUES (?, ?, 'credit', ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iidss", $employe['user_id'], $employe['user_id'], $employe['salaire'], $mon_entreprise['nom'], $destinataire_nom);
            $stmt->execute();
            
            $sql = "UPDATE employes SET derniere_paie = CURDATE() WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $employe['id']);
            $stmt->execute();
        }
        
        $sql = "UPDATE comptes_bancaires_entreprises SET solde = solde - ? WHERE entreprise_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("di", $total_salaires, $mon_entreprise['id']);
        $stmt->execute();
        
        header("Location: emplois.php?tab=gestion_entreprise&sous_tab=staff&success=tous_salaires");
    } else {
        header("Location: emplois.php?tab=gestion_entreprise&sous_tab=staff&error=fonds_tous");
    }
    exit();
    break;
            
        case 'virer_employe':
            $employe_id = $_POST['employe_id'];
            
            $sql = "UPDATE employes SET statut = 'licencie', date_fin = CURDATE() WHERE id = ? AND entreprise_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ii", $employe_id, $mon_entreprise['id']);
            $stmt->execute();
            
            header("Location: emplois.php?tab=gestion_entreprise&sous_tab=staff");
            exit();
            break;
            
        case 'creer_offre':
            $titre = $_POST['titre'];
            $description = $_POST['description'];
            $salaire = $_POST['salaire'];
            $type_contrat = $_POST['type_contrat'];
            $competences = $_POST['competences_requises'];
            $date_expiration = $_POST['date_expiration'];
            
            $sql = "INSERT INTO offres_emploi (entreprise_id, titre, description, salaire, type_contrat, competences_requises, date_expiration) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("issdsss", $mon_entreprise['id'], $titre, $description, $salaire, $type_contrat, $competences, $date_expiration);
            $stmt->execute();
            
            header("Location: emplois.php?tab=gestion_entreprise&sous_tab=offres");
            exit();
            break;
            
        case 'postuler':
            $offre_id = $_POST['offre_id'];
            $motivation = $_POST['motivation'];
            $experience = $_POST['experience'];
            
            $sql = "INSERT INTO candidatures (offre_id, user_id, motivation, experience) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iiss", $offre_id, $user_id, $motivation, $experience);
            $stmt->execute();
            
            header("Location: emplois.php?tab=emplois&success=candidature");
            exit();
            break;
            
        case 'accepter_candidature':
            $candidature_id = $_POST['candidature_id'];
            
            $sql = "SELECT c.*, o.titre, o.salaire, o.type_contrat FROM candidatures c 
                    JOIN offres_emploi o ON c.offre_id = o.id 
                    WHERE c.id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $candidature_id);
            $stmt->execute();
            $candidature = $stmt->get_result()->fetch_assoc();
            
            $sql = "INSERT INTO employes (entreprise_id, user_id, poste, salaire, type_contrat, date_embauche) VALUES (?, ?, ?, ?, ?, CURDATE())";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iisds", $mon_entreprise['id'], $candidature['user_id'], $candidature['titre'], $candidature['salaire'], $candidature['type_contrat']);
            $stmt->execute();
            
            $sql = "UPDATE candidatures SET statut = 'acceptee', date_reponse = NOW() WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $candidature_id);
            $stmt->execute();
            
            $sql = "UPDATE offres_emploi SET statut = 'pourvue' WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $candidature['offre_id']);
            $stmt->execute();
            
            header("Location: emplois.php?tab=gestion_entreprise&sous_tab=candidatures");
            exit();
            break;
            
        case 'refuser_candidature':
            $candidature_id = $_POST['candidature_id'];
            
            $sql = "UPDATE candidatures SET statut = 'refusee', date_reponse = NOW() WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $candidature_id);
            $stmt->execute();
            
            header("Location: emplois.php?tab=gestion_entreprise&sous_tab=candidatures");
            exit();
            break;
    }
}

$tab = isset($_GET['tab']) ? $_GET['tab'] : 'emplois';
$sous_tab = isset($_GET['sous_tab']) ? $_GET['sous_tab'] : 'apercu';

// Récupérer le solde entreprise si nécessaire
$solde_entreprise = 0;
if($mon_entreprise) {
    $sql = "SELECT solde FROM comptes_bancaires_entreprises WHERE entreprise_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $mon_entreprise['id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $solde_entreprise = $result->fetch_assoc()['solde'] ?? 0;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Emplois - Peerkinton</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        .tab-content { display: none; }
        .tab-content.active { display: block; }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow mb-6">
            <div class="max-w-7xl mx-auto px-4">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <a href="dashboard.php" class="text-blue-600 hover:text-blue-800">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Retour au compte
                        </a>
                    </div>
                    <div class="flex items-center">
                        <span class="text-sm font-medium">Pôle Emplois</span>
                    </div>
                </div>
            </div>
        </nav>

        <div class="max-w-7xl mx-auto px-4">
            <!-- Tabs -->
            <div class="border-b border-gray-200 mb-6">
                <nav class="-mb-px flex space-x-8">
                    <a href="?tab=emplois" class="<?php echo $tab == 'emplois' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                        <i class="fas fa-briefcase mr-2"></i> Offres d'emploi
                    </a>
                    <?php if($user['chef_of_entreprise'] || $mon_entreprise): ?>
                    <a href="?tab=gestion_entreprise" class="<?php echo $tab == 'gestion_entreprise' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                        <i class="fas fa-building mr-2"></i> Mon entreprise
                    </a>
                    <?php endif; ?>
                </nav>
            </div>
            

<div id="modalLicenciement" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 w-full max-w-md mx-4">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-red-600">Confirmer le licenciement</h3>
            <button onclick="fermerModalLicenciement()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="mb-6">
            <p class="text-gray-700">Es-tu sûr de vouloir licencier <strong id="modal_nom_employe"></strong> ?</p>
            <p class="text-sm text-gray-500 mt-2">Cette action est irréversible.</p>
        </div>
        
        <form method="POST">
            <input type="hidden" name="action" value="virer_employe">
            <input type="hidden" name="employe_id" id="modal_employe_id">
            
            <div class="flex space-x-3">
                <button type="submit" class="flex-1 bg-red-600 text-white py-2 px-4 rounded hover:bg-red-700">
                    <i class="fas fa-user-minus mr-2"></i>Licencier
                </button>
                <button type="button" onclick="fermerModalLicenciement()" class="px-4 py-2 border rounded text-gray-700 hover:bg-gray-50">
                    Annuler
                </button>
            </div>
        </form>
    </div>
</div>

            <!-- Contenu Emplois -->
            <div class="tab-content <?php echo $tab == 'emplois' ? 'active' : ''; ?>">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <div class="lg:col-span-2">
                        <div class="bg-white shadow rounded-lg">
                            <div class="px-6 py-4 bg-blue-600 text-white rounded-t-lg">
                                <h2 class="text-xl font-bold"><i class="fas fa-briefcase mr-2"></i>Offres d'emploi disponibles</h2>
                            </div>
                            
                            <div class="divide-y">
                                <?php
                                $sql = "SELECT o.*, e.nom as nom_entreprise, e.secteur 
                                        FROM offres_emploi o 
                                        JOIN entreprises e ON o.entreprise_id = e.id 
                                        WHERE o.statut = 'ouverte' 
                                        ORDER BY o.date_creation DESC";
                                $result = $conn->query($sql);
                                
                                if($result && $result->num_rows > 0):
                                    while($offre = $result->fetch_assoc()):
                                        $sql_candidature = "SELECT id FROM candidatures WHERE offre_id = ? AND user_id = ?";
                                        $stmt = $conn->prepare($sql_candidature);
                                        $stmt->bind_param("ii", $offre['id'], $user_id);
                                        $stmt->execute();
                                        $deja_postule = $stmt->get_result()->num_rows > 0;
                                ?>
                                    <div class="p-6">
                                        <div class="flex justify-between">
                                            <div class="flex-1">
                                                <h3 class="text-lg font-semibold"><?php echo htmlspecialchars($offre['titre']); ?></h3>
                                                <p class="text-blue-600 font-medium"><?php echo htmlspecialchars($offre['nom_entreprise']); ?></p>
                                                <p class="text-gray-500 text-sm"><?php echo htmlspecialchars($offre['secteur']); ?></p>
                                                
                                                <div class="mt-2 text-sm text-gray-600 space-x-4">
                                                    <span><i class="fas fa-money-bill-wave mr-1"></i><?php echo number_format($offre['salaire'], 2, ',', ' '); ?> F&</span>
                                                    <span><i class="fas fa-file-contract mr-1"></i><?php echo $offre['type_contrat']; ?></span>
                                                    <span><i class="fas fa-calendar mr-1"></i><?php echo date('d/m/Y', strtotime($offre['date_creation'])); ?></span>
                                                </div>
                                                
                                                <p class="mt-3 text-gray-700"><?php echo nl2br(htmlspecialchars(substr($offre['description'], 0, 200))); ?>...</p>
                                                
                                                <?php if($offre['competences_requises']): ?>
                                                <div class="mt-2">
                                                    <span class="text-sm font-medium">Compétences:</span>
                                                    <span class="text-sm text-gray-600"><?php echo htmlspecialchars($offre['competences_requises']); ?></span>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <div class="ml-4">
                                                <?php if($emploi_actuel): ?>
                                                    <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm">Déjà employé</span>
                                                <?php elseif($deja_postule): ?>
                                                    <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm">Candidature envoyée</span>
                                                <?php else: ?>
                                                    <button onclick="ouvrirModalPostulation(<?php echo $offre['id']; ?>, '<?php echo addslashes($offre['titre']); ?>', '<?php echo addslashes($offre['nom_entreprise']); ?>')" 
                                                            class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                                                        <i class="fas fa-paper-plane mr-1"></i>Postuler
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php 
                                    endwhile;
                                else:
                                ?>
                                    <div class="p-8 text-center">
                                        <i class="fas fa-briefcase text-4xl text-gray-300 mb-4"></i>
                                        <h3 class="text-lg font-medium mb-2">Aucune offre disponible</h3>
                                        <p class="text-gray-500">Reviens plus tard !</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        <?php if($emploi_actuel): ?>
                        <div class="bg-white shadow rounded-lg mb-6">
                            <div class="px-6 py-4 bg-green-600 text-white rounded-t-lg">
                                <h3 class="font-bold"><i class="fas fa-user-tie mr-2"></i>Mon emploi actuel</h3>
                            </div>
                            <div class="p-6">
                                <h4 class="font-semibold"><?php echo htmlspecialchars($emploi_actuel['poste']); ?></h4>
                                <p class="text-blue-600"><?php echo htmlspecialchars($emploi_actuel['nom_entreprise']); ?></p>
                                <div class="mt-4 space-y-2 text-sm">
                                    <div class="flex justify-between">
                                        <span>Salaire:</span>
                                        <span class="font-semibold"><?php echo number_format($emploi_actuel['salaire'], 2, ',', ' '); ?> F&</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span>Contrat:</span>
                                        <span><?php echo $emploi_actuel['type_contrat']; ?></span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span>Embauché le:</span>
                                        <span><?php echo date('d/m/Y', strtotime($emploi_actuel['date_embauche'])); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="bg-white shadow rounded-lg">
                            <div class="px-6 py-4 border-b">
                                <h3 class="font-bold"><i class="fas fa-history mr-2"></i>Mes candidatures</h3>
                            </div>
                            <div class="divide-y">
                                <?php
                                $sql = "SELECT c.*, o.titre, e.nom as nom_entreprise 
                                        FROM candidatures c 
                                        JOIN offres_emploi o ON c.offre_id = o.id 
                                        JOIN entreprises e ON o.entreprise_id = e.id 
                                        WHERE c.user_id = ? 
                                        ORDER BY c.date_candidature DESC LIMIT 5";
                                $stmt = $conn->prepare($sql);
                                $stmt->bind_param("i", $user_id);
                                $stmt->execute();
                                $candidatures = $stmt->get_result();
                                
                                if($candidatures->num_rows > 0):
                                    while($candidature = $candidatures->fetch_assoc()):
                                        $statut_colors = [
                                            'en_attente' => 'bg-yellow-100 text-yellow-800',
                                            'acceptee' => 'bg-green-100 text-green-800',
                                            'refusee' => 'bg-red-100 text-red-800'
                                        ];
                                        $statut_text = [
                                            'en_attente' => 'En attente',
                                            'acceptee' => 'Acceptée',
                                            'refusee' => 'Refusée'
                                        ];
                                ?>
                                    <div class="p-4">
                                        <div class="flex justify-between">
                                            <div>
                                                <h4 class="font-medium text-sm"><?php echo htmlspecialchars($candidature['titre']); ?></h4>
                                                <p class="text-gray-500 text-sm"><?php echo htmlspecialchars($candidature['nom_entreprise']); ?></p>
                                                <p class="text-gray-400 text-xs"><?php echo date('d/m/Y', strtotime($candidature['date_candidature'])); ?></p>
                                            </div>
                                            <span class="px-2 py-1 text-xs rounded-full <?php echo $statut_colors[$candidature['statut']]; ?>">
                                                <?php echo $statut_text[$candidature['statut']]; ?>
                                            </span>
                                        </div>
                                    </div>
                                <?php 
                                    endwhile;
                                else:
                                ?>
                                    <div class="p-4 text-center text-gray-500">
                                        <p>Aucune candidature</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contenu Gestion Entreprise -->
            <div class="tab-content <?php echo $tab == 'gestion_entreprise' ? 'active' : ''; ?>">
                <?php if(!$mon_entreprise): ?>
                    <!-- Formulaire création entreprise -->
                    <div class="bg-white shadow rounded-lg">
                        <div class="px-6 py-4 bg-purple-600 text-white rounded-t-lg">
                            <h2 class="text-xl font-bold"><i class="fas fa-building mr-2"></i>Créer ton entreprise</h2>
                        </div>
                        
                        <form method="POST" class="p-6">
                            <input type="hidden" name="action" value="creer_entreprise">
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium mb-2">Nom de l'entreprise *</label>
                                    <input type="text" name="nom" required class="w-full border rounded px-3 py-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium mb-2">Secteur *</label>
                                    <select name="secteur" required class="w-full border rounded px-3 py-2">
                                        <option value="">Sélectionne</option>
                                        <option value="Technologie">Technologie</option>
                                        <option value="Commerce">Commerce</option>
                                        <option value="Agriculture">Agriculture</option>
                                        <option value="Services">Services</option>
                                        <option value="Autre">Autre</option>
                                    </select>
                                </div>
                                <div class="col-span-2">
                                    <label class="block text-sm font-medium mb-2">Description *</label>
                                    <textarea name="description" rows="3" required class="w-full border rounded px-3 py-2"></textarea>
                                </div>
                                <div class="col-span-2">
                                    <label class="block text-sm font-medium mb-2">Adresse *</label>
                                    <input type="text" name="adresse" required class="w-full border rounded px-3 py-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium mb-2">Téléphone</label>
                                    <input type="text" name="telephone" class="w-full border rounded px-3 py-2">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium mb-2">Email</label>
                                    <input type="email" name="email" class="w-full border rounded px-3 py-2">
                                </div>
                            </div>
                            
                            <div class="mt-6">
                                <button type="submit" class="w-full bg-purple-600 text-white py-3 rounded font-bold hover:bg-purple-700">
                                    <i class="fas fa-rocket mr-2"></i>CRÉER MON ENTREPRISE
                                </button>
                            </div>
                        </form>
                    </div>
                <?php else: ?>
                    <!-- Interface gestion entreprise -->
                    <div class="bg-white shadow rounded-lg mb-6">
                        <div class="px-6 py-4 bg-purple-600 text-white rounded-t-lg">
                            <div class="flex justify-between items-center">
                                <div>
                                    <h2 class="text-xl font-bold"><?php echo htmlspecialchars($mon_entreprise['nom']); ?></h2>
                                    <p class="text-purple-100"><?php echo htmlspecialchars($mon_entreprise['secteur']); ?></p>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm">Solde entreprise</p>
                                    <p class="text-2xl font-bold"><?php echo number_format($solde_entreprise, 2, ',', ' '); ?> F&</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Sous-navigation -->
                        <div class="border-b">
                            <nav class="flex space-x-8 px-6">
                                <a href="?tab=gestion_entreprise&sous_tab=apercu" class="<?php echo $sous_tab == 'apercu' ? 'border-purple-500 text-purple-600' : 'text-gray-500'; ?> py-4 border-b-2 text-sm font-medium">
                                    <i class="fas fa-chart-line mr-1"></i>Aperçu
                                </a>
                                <a href="?tab=gestion_entreprise&sous_tab=offres" class="<?php echo $sous_tab == 'offres' ? 'border-purple-500 text-purple-600' : 'text-gray-500'; ?> py-4 border-b-2 text-sm font-medium">
                                    <i class="fas fa-clipboard-list mr-1"></i>Offres
                                </a>
                                <a href="?tab=gestion_entreprise&sous_tab=candidatures" class="<?php echo $sous_tab == 'candidatures' ? 'border-purple-500 text-purple-600' : 'text-gray-500'; ?> py-4 border-b-2 text-sm font-medium">
                                    <i class="fas fa-user-plus mr-1"></i>Candidatures
                                </a>
                                <a href="?tab=gestion_entreprise&sous_tab=staff" class="<?php echo $sous_tab == 'staff' ? 'border-purple-500 text-purple-600' : 'text-gray-500'; ?> py-4 border-b-2 text-sm font-medium">
                                    <i class="fas fa-users mr-1"></i>Staff
                                </a>
                            </nav>
                        </div>
                    </div>
                    
                    <!-- Contenu selon sous-tab -->
                    <?php if($sous_tab == 'apercu'): ?>
                        <div class="grid grid-cols-4 gap-4 mb-6">
                            <!-- Stats -->
                            <div class="bg-white p-6 rounded-lg shadow">
                                <div class="flex items-center">
                                    <i class="fas fa-users text-blue-600 text-2xl mr-4"></i>
                                    <div>
                                        <p class="text-sm text-gray-500">Employés</p>
                                        <p class="text-2xl font-bold">
                                            <?php
                                            $sql = "SELECT COUNT(*) as total FROM employes WHERE entreprise_id = ? AND statut = 'actif'";
                                            $stmt = $conn->prepare($sql);
                                            $stmt->bind_param("i", $mon_entreprise['id']);
                                            $stmt->execute();
                                            echo $stmt->get_result()->fetch_assoc()['total'];
                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <div class="bg-white p-6 rounded-lg shadow">
                                <div class="flex items-center">
                                    <i class="fas fa-clipboard-list text-green-600 text-2xl mr-4"></i>
                                    <div>
                                        <p class="text-sm text-gray-500">Offres actives</p>
                                        <p class="text-2xl font-bold">
                                            <?php
                                            $sql = "SELECT COUNT(*) as total FROM offres_emploi WHERE entreprise_id = ? AND statut = 'ouverte'";
                                            $stmt = $conn->prepare($sql);
                                            $stmt->bind_param("i", $mon_entreprise['id']);
                                            $stmt->execute();
                                            echo $stmt->get_result()->fetch_assoc()['total'];
                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="bg-white p-6 rounded-lg shadow">
                                <div class="flex items-center">
                                    <i class="fas fa-envelope text-yellow-600 text-2xl mr-4"></i>
                                    <div>
                                        <p class="text-sm text-gray-500">Candidatures</p>
                                        <p class="text-2xl font-bold">
                                            <?php
                                            $sql = "SELECT COUNT(*) as total FROM candidatures c 
                                                    JOIN offres_emploi o ON c.offre_id = o.id 
                                                    WHERE o.entreprise_id = ? AND c.statut = 'en_attente'";
                                            $stmt = $conn->prepare($sql);
                                            $stmt->bind_param("i", $mon_entreprise['id']);
                                            $stmt->execute();
                                            echo $stmt->get_result()->fetch_assoc()['total'];
                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="bg-white p-6 rounded-lg shadow">
                                <div class="flex items-center">
                                    <i class="fas fa-chart-line text-purple-600 text-2xl mr-4"></i>
                                    <div>
                                        <p class="text-sm text-gray-500">Revenus</p>
                                        <p class="text-lg font-bold">0 F&</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-white shadow rounded-lg p-6">
                            <h3 class="text-lg font-bold mb-4">Informations entreprise</h3>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <p class="text-sm text-gray-500">Nom</p>
                                    <p class="font-medium"><?php echo htmlspecialchars($mon_entreprise['nom']); ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Secteur</p>
                                    <p class="font-medium"><?php echo htmlspecialchars($mon_entreprise['secteur']); ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Adresse</p>
                                    <p class="font-medium"><?php echo htmlspecialchars($mon_entreprise['adresse']); ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">ID Banca
                                    </p>
                                    <p class="font-mono"><?php echo $mon_entreprise['id_bancaire_entreprise']; ?></p>
                               </div>
                               <div>
                                   <p class="text-sm text-gray-500">Date de création</p>
                                   <p class="font-medium"><?php echo date('d/m/Y', strtotime($mon_entreprise['date_creation'])); ?></p>
                               </div>
                           </div>
                       </div>
                   <?php endif; ?>
                   
                   <?php if($sous_tab == 'staff'): ?>
    <?php if(isset($_GET['success'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php if($_GET['success'] == 'salaire'): ?>
                <p><i class="fas fa-check mr-2"></i>Salaire versé avec succès !</p>
            <?php elseif($_GET['success'] == 'tous_salaires'): ?>
                <p><i class="fas fa-check mr-2"></i>Tous les salaires ont été versés !</p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    
    <?php if(isset($_GET['error'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php if($_GET['error'] == 'fonds'): ?>
                <p><i class="fas fa-exclamation-triangle mr-2"></i>Fonds insuffisants pour verser ce salaire !</p>
            <?php elseif($_GET['error'] == 'fonds_tous'): ?>
                <p><i class="fas fa-exclamation-triangle mr-2"></i>Fonds insuffisants pour verser tous les salaires !</p>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow rounded-lg">
        <div class="px-6 py-4 border-b flex justify-between items-center">
            <h3 class="text-lg font-bold">Gestion du personnel</h3>
            
            <?php
            $sql = "SELECT COUNT(*) as nb_actifs, SUM(salaire) as total_salaires FROM employes WHERE entreprise_id = ? AND statut = 'actif'";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $mon_entreprise['id']);
            $stmt->execute();
            $stats = $stmt->get_result()->fetch_assoc();
            ?>
            
            <?php if($stats['nb_actifs'] > 0): ?>
                <div class="flex items-center space-x-4">
                    <div class="text-sm">
                        <span class="text-gray-500">Total salaires: </span>
                        <span class="font-bold"><?php echo number_format($stats['total_salaires'], 2, ',', ' '); ?> F&</span>
                    </div>
                    <button onclick="confirmerTousSalaires(<?php echo $stats['total_salaires']; ?>)" 
                            class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                        <i class="fas fa-money-bill-wave mr-1"></i>Verser tous les salaires
                    </button>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="divide-y">
            <?php
            $sql = "SELECT e.*, i.nom, i.prenom, u.email 
                    FROM employes e 
                    LEFT JOIN identites i ON e.user_id = i.user_id 
                    JOIN users u ON e.user_id = u.id 
                    WHERE e.entreprise_id = ? 
                    ORDER BY e.statut ASC, e.date_embauche DESC";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $mon_entreprise['id']);
            $stmt->execute();
            $employes = $stmt->get_result();
            
            if($employes->num_rows > 0):
                while($employe = $employes->fetch_assoc()):
                    $statut_colors = [
                        'actif' => 'bg-green-100 text-green-800',
                        'licencie' => 'bg-red-100 text-red-800',
                        'demission' => 'bg-gray-100 text-gray-800'
                    ];
                    $statut_text = [
                        'actif' => 'Actif',
                        'licencie' => 'Licencié',
                        'demission' => 'Démission'
                    ];
            ?>
                <div class="p-6">
                    <div class="flex justify-between">
                        <div class="flex-1">
                            <div class="flex items-center space-x-3 mb-2">
                                <h4 class="text-lg font-semibold">
                                    <?php echo ($employe['nom'] && $employe['prenom']) ? $employe['nom'] . ' ' . $employe['prenom'] : $employe['email']; ?>
                                </h4>
                                <span class="px-2 py-1 text-xs rounded-full <?php echo $statut_colors[$employe['statut']]; ?>">
                                    <?php echo $statut_text[$employe['statut']]; ?>
                                </span>
                            </div>
                            
                            <div class="grid grid-cols-3 gap-4 text-sm">
                                <div>
                                    <p class="text-gray-500">Poste</p>
                                    <p class="font-medium"><?php echo htmlspecialchars($employe['poste']); ?></p>
                                </div>
                                <div>
                                    <p class="text-gray-500">Salaire</p>
                                    <p class="font-medium"><?php echo number_format($employe['salaire'], 2, ',', ' '); ?> F&</p>
                                </div>
                                <div>
                                    <p class="text-gray-500">Type de contrat</p>
                                    <p class="font-medium"><?php echo $employe['type_contrat']; ?></p>
                                </div>
                                <div>
                                    <p class="text-gray-500">Date d'embauche</p>
                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($employe['date_embauche'])); ?></p>
                                </div>
                                <?php if($employe['derniere_paie']): ?>
                                <div>
                                    <p class="text-gray-500">Dernière paie</p>
                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($employe['derniere_paie'])); ?></p>
                                </div>
                                <?php else: ?>
                                <div>
                                    <p class="text-gray-500">Dernière paie</p>
                                    <p class="font-medium text-red-600">Jamais payé</p>
                                </div>
                                <?php endif; ?>
                                <?php if($employe['date_fin']): ?>
                                <div>
                                    <p class="text-gray-500">Date de fin</p>
                                    <p class="font-medium"><?php echo date('d/m/Y', strtotime($employe['date_fin'])); ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <?php if($employe['statut'] == 'actif'): ?>
                            <div class="ml-6 flex flex-col space-y-2">
                                <button onclick="confirmerVersementSalaire(<?php echo $employe['id']; ?>, '<?php echo addslashes(($employe['nom'] && $employe['prenom']) ? $employe['nom'] . ' ' . $employe['prenom'] : $employe['email']); ?>', <?php echo $employe['salaire']; ?>)" 
                                        class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                    <i class="fas fa-money-bill-wave mr-1"></i>Verser salaire
                                </button>
                                <button onclick="confirmerLicenciement(<?php echo $employe['id']; ?>, '<?php echo addslashes(($employe['nom'] && $employe['prenom']) ? $employe['nom'] . ' ' . $employe['prenom'] : $employe['email']); ?>')" 
                                        class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm">
                                    <i class="fas fa-user-minus mr-1"></i>Licencier
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php 
                endwhile;
            else:
            ?>
                <div class="p-8 text-center">
                    <i class="fas fa-users text-4xl text-gray-300 mb-4"></i>
                    <h3 class="text-lg font-medium mb-2">Aucun employé</h3>
                    <p class="text-gray-500">Recrute du personnel via tes offres d'emploi.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
                   
                   <?php if($sous_tab == 'offres'): ?>
                       <div class="bg-white shadow rounded-lg">
                           <div class="px-6 py-4 border-b flex justify-between items-center">
                               <h3 class="text-lg font-bold">Mes offres d'emploi</h3>
                               <button onclick="ouvrirModalOffre()" class="bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700">
                                   <i class="fas fa-plus mr-2"></i>Nouvelle offre
                               </button>
                           </div>
                           
                           <div class="divide-y">
                               <?php
                               $sql = "SELECT * FROM offres_emploi WHERE entreprise_id = ? ORDER BY date_creation DESC";
                               $stmt = $conn->prepare($sql);
                               $stmt->bind_param("i", $mon_entreprise['id']);
                               $stmt->execute();
                               $offres = $stmt->get_result();
                               
                               if($offres->num_rows > 0):
                                   while($offre = $offres->fetch_assoc()):
                                       $sql_candidatures = "SELECT COUNT(*) as total FROM candidatures WHERE offre_id = ?";
                                       $stmt = $conn->prepare($sql_candidatures);
                                       $stmt->bind_param("i", $offre['id']);
                                       $stmt->execute();
                                       $nb_candidatures = $stmt->get_result()->fetch_assoc()['total'];
                                       
                                       $statut_colors = [
                                           'ouverte' => 'bg-green-100 text-green-800',
                                           'fermee' => 'bg-red-100 text-red-800',
                                           'pourvue' => 'bg-blue-100 text-blue-800'
                                       ];
                               ?>
                                   <div class="p-6">
                                       <div class="flex justify-between">
                                           <div class="flex-1">
                                               <h4 class="text-lg font-semibold"><?php echo htmlspecialchars($offre['titre']); ?></h4>
                                               <div class="mt-2 text-sm text-gray-600 space-x-4">
                                                   <span><i class="fas fa-money-bill-wave mr-1"></i><?php echo number_format($offre['salaire'], 2, ',', ' '); ?> F&</span>
                                                   <span><i class="fas fa-file-contract mr-1"></i><?php echo $offre['type_contrat']; ?></span>
                                                   <span><i class="fas fa-users mr-1"></i><?php echo $nb_candidatures; ?> candidature(s)</span>
                                               </div>
                                               <p class="mt-3 text-gray-700"><?php echo nl2br(htmlspecialchars(substr($offre['description'], 0, 150))); ?>...</p>
                                           </div>
                                           <div class="ml-6">
                                               <span class="px-2 py-1 text-xs rounded-full <?php echo $statut_colors[$offre['statut']]; ?>">
                                                   <?php echo ucfirst($offre['statut']); ?>
                                               </span>
                                           </div>
                                       </div>
                                   </div>
                               <?php 
                                   endwhile;
                               else:
                               ?>
                                   <div class="p-8 text-center">
                                       <i class="fas fa-clipboard-list text-4xl text-gray-300 mb-4"></i>
                                       <h3 class="text-lg font-medium mb-2">Aucune offre d'emploi</h3>
                                       <p class="text-gray-500 mb-4">Crée ta première offre pour recruter.</p>
                                       <button onclick="ouvrirModalOffre()" class="bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700">
                                           <i class="fas fa-plus mr-2"></i>Créer une offre
                                       </button>
                                   </div>
                               <?php endif; ?>
                           </div>
                       </div>
                   <?php endif; ?>
                   
                   <?php if($sous_tab == 'candidatures'): ?>
                       <div class="bg-white shadow rounded-lg">
                           <div class="px-6 py-4 border-b">
                               <h3 class="text-lg font-bold">Candidatures reçues</h3>
                           </div>
                           
                           <div class="divide-y">
                               <?php
                               $sql = "SELECT c.*, o.titre, i.nom, i.prenom, u.email 
                                       FROM candidatures c 
                                       JOIN offres_emploi o ON c.offre_id = o.id 
                                       LEFT JOIN identites i ON c.user_id = i.user_id 
                                       JOIN users u ON c.user_id = u.id 
                                       WHERE o.entreprise_id = ? 
                                       ORDER BY c.date_candidature DESC";
                               $stmt = $conn->prepare($sql);
                               $stmt->bind_param("i", $mon_entreprise['id']);
                               $stmt->execute();
                               $candidatures = $stmt->get_result();
                               
                               if($candidatures->num_rows > 0):
                                   while($candidature = $candidatures->fetch_assoc()):
                                       $statut_colors = [
                                           'en_attente' => 'bg-yellow-100 text-yellow-800',
                                           'acceptee' => 'bg-green-100 text-green-800',
                                           'refusee' => 'bg-red-100 text-red-800'
                                       ];
                                       $statut_text = [
                                           'en_attente' => 'En attente',
                                           'acceptee' => 'Acceptée',
                                           'refusee' => 'Refusée'
                                       ];
                               ?>
                                   <div class="p-6">
                                       <div class="flex justify-between">
                                           <div class="flex-1">
                                               <div class="flex items-center space-x-3 mb-2">
                                                   <h4 class="text-lg font-semibold">
                                                       <?php echo ($candidature['nom'] && $candidature['prenom']) ? $candidature['nom'] . ' ' . $candidature['prenom'] : $candidature['email']; ?>
                                                   </h4>
                                                   <span class="px-2 py-1 text-xs rounded-full <?php echo $statut_colors[$candidature['statut']]; ?>">
                                                       <?php echo $statut_text[$candidature['statut']]; ?>
                                                   </span>
                                               </div>
                                               
                                               <p class="text-sm text-gray-600 mb-2">
                                                   <i class="fas fa-briefcase mr-1"></i>
                                                   Candidature pour: <strong><?php echo htmlspecialchars($candidature['titre']); ?></strong>
                                               </p>
                                               
                                               <p class="text-sm text-gray-500 mb-3">
                                                   <i class="fas fa-calendar mr-1"></i>
                                                   Postulé le <?php echo date('d/m/Y à H:i', strtotime($candidature['date_candidature'])); ?>
                                               </p>
                                               
                                               <div class="bg-gray-50 p-4 rounded">
                                                   <h5 class="font-medium mb-2">Lettre de motivation:</h5>
                                                   <p class="text-sm text-gray-700"><?php echo nl2br(htmlspecialchars($candidature['motivation'])); ?></p>
                                                   
                                                   <?php if($candidature['experience']): ?>
                                                       <h5 class="font-medium mt-4 mb-2">Expérience:</h5>
                                                       <p class="text-sm text-gray-700"><?php echo nl2br(htmlspecialchars($candidature['experience'])); ?></p>
                                                   <?php endif; ?>
                                               </div>
                                           </div>
                                           
                                           <?php if($candidature['statut'] == 'en_attente'): ?>
                                               <div class="ml-6 flex flex-col space-y-2">
                                                   <form method="POST">
                                                       <input type="hidden" name="action" value="accepter_candidature">
                                                       <input type="hidden" name="candidature_id" value="<?php echo $candidature['id']; ?>">
                                                       <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm w-full">
                                                           <i class="fas fa-check mr-1"></i>Accepter
                                                       </button>
                                                   </form>
                                                   
                                                   <form method="POST">
                                                       <input type="hidden" name="action" value="refuser_candidature">
                                                       <input type="hidden" name="candidature_id" value="<?php echo $candidature['id']; ?>">
                                                       <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm w-full">
                                                           <i class="fas fa-times mr-1"></i>Refuser
                                                       </button>
                                                   </form>
                                               </div>
                                           <?php endif; ?>
                                       </div>
                                   </div>
                               <?php 
                                   endwhile;
                               else:
                               ?>
                                   <div class="p-8 text-center">
                                       <i class="fas fa-user-plus text-4xl text-gray-300 mb-4"></i>
                                       <h3 class="text-lg font-medium mb-2">Aucune candidature</h3>
                                       <p class="text-gray-500">Publie des offres pour recevoir des candidatures.</p>
                                   </div>
                               <?php endif; ?>
                           </div>
                       </div>
                   <?php endif; ?>
               <?php endif; ?>
           </div>
       </div>
   </div>

   <!-- Modal Postulation -->
   <div id="modalPostulation" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
       <div class="bg-white rounded-lg p-6 w-full max-w-md mx-4">
           <div class="flex justify-between items-center mb-4">
               <h3 class="text-lg font-semibold">Postuler à cette offre</h3>
               <button onclick="fermerModalPostulation()" class="text-gray-400 hover:text-gray-600">
                   <i class="fas fa-times"></i>
               </button>
           </div>
           
           <form method="POST">
               <input type="hidden" name="action" value="postuler">
               <input type="hidden" name="offre_id" id="modal_offre_id">
               
               <div class="mb-4">
                   <label class="block text-sm font-medium mb-2">Poste:</label>
                   <p id="modal_titre" class="text-sm font-medium"></p>
                   <p id="modal_entreprise" class="text-sm text-gray-500"></p>
               </div>
               
               <div class="mb-4">
                   <label for="motivation" class="block text-sm font-medium mb-2">Lettre de motivation *</label>
                   <textarea name="motivation" id="motivation" rows="4" required class="w-full border rounded px-3 py-2" placeholder="Explique pourquoi tu veux rejoindre cette entreprise..."></textarea>
               </div>
               
               <div class="mb-6">
                   <label for="experience" class="block text-sm font-medium mb-2">Expérience professionnelle</label>
                   <textarea name="experience" id="experience" rows="3" class="w-full border rounded px-3 py-2" placeholder="Décris ton expérience (optionnel)..."></textarea>
               </div>
               
               <div class="flex space-x-3">
                   <button type="submit" class="flex-1 bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">
                       <i class="fas fa-paper-plane mr-2"></i>Envoyer
                   </button>
                   <button type="button" onclick="fermerModalPostulation()" class="px-4 py-2 border rounded text-gray-700 hover:bg-gray-50">
                       Annuler
                   </button>
               </div>
           </form>
       </div>
   </div>

   <!-- Modal Créer Offre -->
   <div id="modalOffre" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
       <div class="bg-white rounded-lg p-6 w-full max-w-2xl mx-4 max-h-screen overflow-y-auto">
           <div class="flex justify-between items-center mb-4">
               <h3 class="text-lg font-semibold">Créer une offre d'emploi</h3>
               <button onclick="fermerModalOffre()" class="text-gray-400 hover:text-gray-600">
                   <i class="fas fa-times"></i>
               </button>
           </div>
           
           <form method="POST">
               <input type="hidden" name="action" value="creer_offre">
               
               <div class="grid grid-cols-2 gap-4 mb-4">
                   <div class="col-span-2">
                       <label for="titre" class="block text-sm font-medium mb-2">Titre du poste *</label>
                       <input type="text" name="titre" id="titre" required class="w-full border rounded px-3 py-2">
                   </div>
                   
                   <div>
                       <label for="salaire" class="block text-sm font-medium mb-2">Salaire (F&) *</label>
                       <input type="number" step="0.01" min="0" name="salaire" id="salaire" required class="w-full border rounded px-3 py-2">
                   </div>
                   
                   <div>
                       <label for="type_contrat" class="block text-sm font-medium mb-2">Type de contrat *</label>
                       <select name="type_contrat" id="type_contrat" required class="w-full border rounded px-3 py-2">
                           <option value="">Sélectionne</option>
                           <option value="CDI">CDI</option>
                           <option value="CDD">CDD</option>
                           <option value="Stage">Stage</option>
                           <option value="Freelance">Freelance</option>
                       </select>
                   </div>
                   
                   <div class="col-span-2">
                       <label for="description" class="block text-sm font-medium mb-2">Description du poste *</label>
                       <textarea name="description" id="description" rows="4" required class="w-full border rounded px-3 py-2" placeholder="Décris les missions, responsabilités..."></textarea>
                   </div>
                   
                   <div class="col-span-2">
                       <label for="competences_requises" class="block text-sm font-medium mb-2">Compétences requises</label>
                       <textarea name="competences_requises" id="competences_requises" rows="2" class="w-full border rounded px-3 py-2" placeholder="Liste les compétences nécessaires..."></textarea>
                   </div>
                   
                   <div>
                       <label for="date_expiration" class="block text-sm font-medium mb-2">Date d'expiration</label>
                       <input type="date" name="date_expiration" id="date_expiration" class="w-full border rounded px-3 py-2">
                   </div>
               </div>
               
               <div class="flex space-x-3">
                   <button type="submit" class="flex-1 bg-purple-600 text-white py-2 px-4 rounded hover:bg-purple-700">
                       <i class="fas fa-plus mr-2"></i>Créer l'offre
                   </button>
                   <button type="button" onclick="fermerModalOffre()" class="px-4 py-2 border rounded text-gray-700 hover:bg-gray-50">
                       Annuler
                   </button>
               </div>
           </form>
       </div>
   </div>
   
   <div id="modalVersementSalaire" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 w-full max-w-md mx-4">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-green-600">Verser le salaire</h3>
            <button onclick="fermerModalVersementSalaire()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="mb-6">
            <p class="text-gray-700">Verser le salaire de <strong id="modal_nom_employe_salaire"></strong> ?</p>
            <p class="text-lg font-bold text-green-600 mt-2">Montant: <span id="modal_montant_salaire"></span> F&</p>
            <p class="text-sm text-gray-500 mt-1">Solde entreprise: <?php echo number_format($solde_entreprise, 2, ',', ' '); ?> F&</p>
        </div>
        
        <form method="POST">
            <input type="hidden" name="action" value="verser_salaire">
            <input type="hidden" name="employe_id" id="modal_employe_id_salaire">
            
            <div class="flex space-x-3">
                <button type="submit" class="flex-1 bg-green-600 text-white py-2 px-4 rounded hover:bg-green-700">
                    <i class="fas fa-money-bill-wave mr-2"></i>Verser
                </button>
                <button type="button" onclick="fermerModalVersementSalaire()" class="px-4 py-2 border rounded text-gray-700 hover:bg-gray-50">
                    Annuler
                </button>
            </div>
        </form>
    </div>
</div>

<div id="modalTousSalaires" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 w-full max-w-md mx-4">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-green-600">Verser tous les salaires</h3>
            <button onclick="fermerModalTousSalaires()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="mb-6">
            <p class="text-gray-700">Verser tous les salaires des employés actifs ?</p>
            <p class="text-lg font-bold text-green-600 mt-2">Total: <span id="modal_total_salaires"></span> F&</p>
            <p class="text-sm text-gray-500 mt-1">Solde entreprise: <?php echo number_format($solde_entreprise, 2, ',', ' '); ?> F&</p>
        </div>
        
        <form method="POST">
            <input type="hidden" name="action" value="verser_tous_salaires">
            
            <div class="flex space-x-3">
                <button type="submit" class="flex-1 bg-green-600 text-white py-2 px-4 rounded hover:bg-green-700">
                    <i class="fas fa-money-bill-wave mr-2"></i>Verser tout
                </button>
                <button type="button" onclick="fermerModalTousSalaires()" class="px-4 py-2 border rounded text-gray-700 hover:bg-gray-50">
                    Annuler
                </button>
            </div>
        </form>
    </div>
</div>



   <script>
   
            function confirmerVersementSalaire(employe_id, nom, montant) {
    document.getElementById('modal_employe_id_salaire').value = employe_id;
    document.getElementById('modal_nom_employe_salaire').textContent = nom;
    document.getElementById('modal_montant_salaire').textContent = new Intl.NumberFormat('fr-FR', {minimumFractionDigits: 2}).format(montant);
    document.getElementById('modalVersementSalaire').classList.remove('hidden');
    document.getElementById('modalVersementSalaire').classList.add('flex');
}

function fermerModalVersementSalaire() {
    document.getElementById('modalVersementSalaire').classList.add('hidden');
    document.getElementById('modalVersementSalaire').classList.remove('flex');
}

function confirmerTousSalaires(total) {
    document.getElementById('modal_total_salaires').textContent = new Intl.NumberFormat('fr-FR', {minimumFractionDigits: 2}).format(total);
    document.getElementById('modalTousSalaires').classList.remove('hidden');
    document.getElementById('modalTousSalaires').classList.add('flex');
}

function fermerModalTousSalaires() {
    document.getElementById('modalTousSalaires').classList.add('hidden');
    document.getElementById('modalTousSalaires').classList.remove('flex');
}
   
           function confirmerLicenciement(employe_id, nom) {
            document.getElementById('modal_employe_id').value = employe_id;
            document.getElementById('modal_nom_employe').textContent = nom;
            document.getElementById('modalLicenciement').classList.remove('hidden');
            document.getElementById('modalLicenciement').classList.add('flex');
        }
        
        function fermerModalLicenciement() {
            document.getElementById('modalLicenciement').classList.add('hidden');
            document.getElementById('modalLicenciement').classList.remove('flex');
        }

       function ouvrirModalPostulation(offre_id, titre, entreprise) {
           document.getElementById('modal_offre_id').value = offre_id;
           document.getElementById('modal_titre').textContent = titre;
           document.getElementById('modal_entreprise').textContent = entreprise;
           document.getElementById('modalPostulation').classList.remove('hidden');
           document.getElementById('modalPostulation').classList.add('flex');
       }

       function fermerModalPostulation() {
           document.getElementById('modalPostulation').classList.add('hidden');
           document.getElementById('modalPostulation').classList.remove('flex');
           document.getElementById('motivation').value = '';
           document.getElementById('experience').value = '';
       }

       function ouvrirModalOffre() {
           document.getElementById('modalOffre').classList.remove('hidden');
           document.getElementById('modalOffre').classList.add('flex');
       }

       function fermerModalOffre() {
           document.getElementById('modalOffre').classList.add('hidden');
           document.getElementById('modalOffre').classList.remove('flex');
       }
   </script>
</body>
</html>