<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton</title>
    <link rel="icon" type="image/png" href="logo-transparent.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .hamburger {
            cursor: pointer;
            padding: 10px;
            display: block;
        }
        .hamburger span {
            display: block;
            width: 25px;
            height: 3px;
            background: #000;
            margin: 5px 0;
            transition: 0.3s;
        }
        .hamburger.active span:nth-child(1) {
            transform: rotate(-45deg) translate(-5px, 6px);
        }
        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }
        .hamburger.active span:nth-child(3) {
            transform: rotate(45deg) translate(-5px, -6px);
        }
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            z-index: 100;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }
        .mobile-menu.show {
            display: flex;
        }
        .close-btn {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 40px;
            height: 40px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .close-btn::before,
        .close-btn::after {
            content: '';
            position: absolute;
            width: 25px;
            height: 3px;
            background: #000;
        }
        .close-btn::before {
            transform: rotate(45deg);
        }
        .close-btn::after {
            transform: rotate(-45deg);
        }
        .nav-links {
            display: none;
        }
        @media (min-width: 768px) {
            .nav-links {
                display: flex;
                align-items: center;
                gap: 2rem;
            }
            .hamburger {
                display: none;
            }
        }
        .status-indicator {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 6px;
        }
        .status-open {
            background-color: #10b981;
        }
        .status-closed {
            background-color: #ef4444;
        }
        .status-maintenance {
            background-color: #f59e0b;
        }
        .faq-item {
            cursor: pointer;
        }
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
        }
        .faq-answer.active {
            max-height: 500px;
        }
        .faq-icon {
            transition: transform 0.3s ease;
        }
        .faq-icon.active {
            transform: rotate(180deg);
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white text-gray-900">
    <header class="w-full px-4 sm:px-6 py-4">
        <div class="max-w-5xl mx-auto flex justify-between items-center relative">
            <img src="logo.png" alt="Peerkinton Logo" class="h-6 sm:h-8">
            <div class="nav-links">
                <a href="http://88.151.197.15:8222/#world:-186:0:-912:3138:-1.56:0:0:0:perspective" class="text-gray-700 hover:text-black font-medium text-sm">Carte</a>
                <a href="https://wiki.peerkinton.com" class="text-gray-700 hover:text-black font-medium text-sm">Wiki</a>
                <a href="https://gov.peerkinton.com" class="text-gray-700 hover:text-black font-medium text-sm">Lois</a>
                <a href="https://discord.gg/qK8c3n8qAx" class="flex items-center space-x-2 text-purple-600 hover:text-purple-700 font-medium text-sm">
                    <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515a.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0a12.64 12.64 0 0 0-.617-1.25a.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057a19.9 19.9 0 0 0 5.993 3.03a.078.078 0 0 0 .084-.028a14.09 14.09 0 0 0 1.226-1.994a.076.076 0 0 0-.041-.106a13.107 13.107 0 0 1-1.872-.892a.077.077 0 0 1-.008-.128a10.2 10.2 0 0 0 .372-.292a.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127a12.299 12.299 0 0 1-1.873.892a.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028a19.839 19.839 0 0 0 6.002-3.03a.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.956-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.955-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.946 2.418-2.157 2.418z"/>
                    </svg>
                    <span>Discord</span>
                </a>
                <a href="/login" class="bg-black text-white px-6 py-2 font-medium rounded-full text-sm uppercase tracking-wider hover:bg-gray-800 transition-colors">
                    Compte
                </a>
            </div>
            <div class="flex items-center space-x-4 md:hidden">
                <div class="hamburger" onclick="toggleMobileMenu()">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <a href="/login" class="bg-black text-white px-4 py-2 font-medium rounded-full text-xs uppercase tracking-wider hover:bg-gray-800 transition-colors">
                    Compte
                </a>
            </div>
        </div>
    </header>

    <div class="mobile-menu" id="mobileMenu">
        <div class="close-btn" onclick="toggleMobileMenu()"></div>
        <div class="text-center space-y-8">
            <a href="http://88.151.197.15:8222/#world:-186:0:-912:3138:-1.56:0:0:0:perspective" class="block text-2xl font-medium text-gray-700 hover:text-black" onclick="toggleMobileMenu()">Carte</a>
            <a href="https://wiki.peerkinton.com" class="block text-2xl font-medium text-gray-700 hover:text-black" onclick="toggleMobileMenu()">Wiki</a>
            <a href="https://gov.peerkinton.com" class="block text-2xl font-medium text-gray-700 hover:text-black" onclick="toggleMobileMenu()">Lois</a>
            <a href="https://discord.gg/qK8c3n8qAx" class="flex items-center justify-center space-x-3 text-2xl font-medium text-purple-600 hover:text-purple-700" onclick="toggleMobileMenu()">
                <svg class="w-8 h-8" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515a.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0a12.64 12.64 0 0 0-.617-1.25a.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057a19.9 19.9 0 0 0 5.993 3.03a.078.078 0 0 0 .084-.028a14.09 14.09 0 0 0 1.226-1.994a.076.076 0 0 0-.041-.106a13.107 13.107 0 0 1-1.872-.892a.077.077 0 0 1-.008-.128a10.2 10.2 0 0 0 .372-.292a.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127a12.299 12.299 0 0 1-1.873.892a.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028a19.839 19.839 0 0 0 6.002-3.03a.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.956-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419c0-1.333.955-2.419 2.157-2.419c1.21 0 2.176 1.096 2.157 2.42c0 1.333-.946 2.418-2.157 2.418z"/>
                </svg>
                <span>Discord</span>
            </a>
        </div>
    </div>

    <div class="max-w-5xl mx-auto px-4 sm:px-6 py-8 sm:py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 items-center mb-16">
            <div>
                <h1 class="text-3xl sm:text-5xl font-medium mb-4">Découvrez une civilisation.</h1>
                <p class="text-gray-600 mb-8 text-base sm:text-lg">Des pays, des villes, remplis de surprise et d'aventure élégante dans un espace extrêmement grands.</p>
                <div class="bg-gray-50 rounded-lg p-4 mb-6">
                    <div class="flex items-center justify-between mb-3">
                        <div class="flex-1">
                            <p class="text-xs text-gray-500 mb-1">Adresse serveur</p>
                            <p class="font-mono text-sm sm:text-base font-medium" id="serverAddress">play.peerkinton.com</p>
                        </div>
                        <button onclick="copyAddress()" class="bg-black text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-gray-800 transition-colors">
                            Copier
                        </button>
                    </div>
                    <div class="pt-3 border-t border-gray-200">
                        <div class="flex items-center">
                            <span class="status-indicator" id="statusIndicator"></span>
                            <span class="text-xs sm:text-sm font-medium" id="statusValue"></span>
                        </div>
                    </div>
                </div>
            </div>
            <div>
                <img src="font-folium.png" alt="Peerkinton City View" class="w-full h-auto rounded-lg">
            </div>
        </div>

        <section class="py-12 sm:py-16">
            <div class="text-center mb-10">
                <h2 class="text-2xl sm:text-4xl font-medium mb-3">Membres du Royaume</h2>
                <p class="text-gray-600 text-sm sm:text-base">Territoires membres et indépendants</p>
            </div>
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <div>
                    <h3 class="text-xl sm:text-2xl font-medium mb-6">Territoires Membres</h3>
                    <div class="space-y-4">
                        <div class="bg-green-50 rounded-lg p-5">
                            <h4 class="text-lg font-medium mb-3 text-green-800">Pays de Lukosia</h4>
                            <div class="space-y-1.5 text-sm text-green-700">
                                <div class="flex justify-between">
                                    <span>Folium</span>
                                    <span class="text-xs text-green-600">Capitale</span>
                                </div>
                                <div>Morithan</div>
                                <div>MayFlower</div>
                                <div>BelleVerre</div>
                                <div>Herbosch</div>
                            </div>
                        </div>
                        
                        <div class="bg-green-50 rounded-lg p-5">
                            <h4 class="text-lg font-medium mb-3 text-green-800">Enderia</h4>
                            <div class="space-y-1.5 text-sm text-green-700">
                                <div>Village Bouleau</div>
                                <div>Côte Maritime</div>
                            </div>
                        </div>

                        <div class="bg-green-50 rounded-lg p-5">
                            <h4 class="text-lg font-medium mb-3 text-green-800">Continent Midorien</h4>
                            <div class="space-y-1.5 text-sm text-green-700">
                                <div>Costa Nerra</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <h3 class="text-xl sm:text-2xl font-medium mb-6">Territoires Indépendants</h3>
                    <div class="space-y-4">
                        <div class="bg-red-50 rounded-lg p-5">
                            <h4 class="text-lg font-medium mb-3 text-red-800">Nova Republic</h4>
                            <div class="space-y-1.5 text-sm text-red-700">
                                <div class="flex justify-between">
                                    <span>Nova Capitale</span>
                                    <span class="text-xs text-red-600">Capitale</span>
                                </div>
                                <div>Nova grande-ville</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mt-10 bg-gray-50 rounded-lg p-6">
                <h3 class="text-lg sm:text-xl font-medium mb-4 text-center">Statistiques</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <div class="text-center">
                        <div class="text-2xl font-medium text-green-600">8</div>
                        <div class="text-xs text-gray-600">Villes membres</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-medium text-red-600">2</div>
                        <div class="text-xs text-gray-600">Villes indépendantes</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-medium text-blue-600">3</div>
                        <div class="text-xs text-gray-600">Pays membres</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-medium text-black">80%</div>
                        <div class="text-xs text-gray-600">Unification</div>
                    </div>
                </div>
            </div>
        </section>

        <section class="py-12 sm:py-16">
            <div class="text-center mb-10">
                <h2 class="text-2xl sm:text-4xl font-medium mb-3">Le Royaume de Peerkinton</h2>
                <p class="text-gray-600 text-sm sm:text-base">Histoire et traditions de notre royaume</p>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-10">
                <div>
                    <h3 class="text-xl sm:text-2xl font-medium mb-4">Notre Histoire</h3>
                    <div class="space-y-3 text-gray-600 text-sm sm:text-base">
                        <p>Fondé il y a plus de trois siècles par le Roi Merian, le Royaume de Peerkinton est né de la vision d'un monarque éclairé qui souhaitait créer une société où l'aventure et l'élégance se mélangent harmonieusement.</p>
                        <p>Au fil des décennies, Peerkinton a développé et donné naissance à sa première ville qui est maintenant sa capitale, appelée Folium. Les villes ouvrières et citoyennes se sont développées par la suite.</p>
                        <p>Les rues de Folium, grandes et qui font découvrir une capitale harmonieuse et vaste, résonnent des histoires de chevaliers, de marchands, d'artisans et d'explorateurs qui façonnent quotidiennement l'identité unique de notre terre.</p>
                    </div>
                </div>

                <div>
                    <h3 class="text-xl sm:text-2xl font-medium mb-4">Culture & Traditions</h3>
                    <div class="space-y-3 text-gray-600 text-sm sm:text-base">
                        <p>Le Royaume de Peerkinton est réputé pour sa culture raffinée où l'art atteint des sommets d'excellence. Nos habitants cultivent l'art de la narration, transformant chaque interaction en une aventure mémorable.</p>
                        <p>Les traditions ancestrales se mélangent aux innovations modernes, créant un environnement unique où le passé et le présent coexistent en parfaite harmonie. Les festivals saisonniers, les tournois et les marchés artisanaux rythment la vie quotidienne.</p>
                        <p>L'hospitalité peerkintonaise est légendaire. Que tu sois noble ou roturier, aventurier ou commerçant, le royaume t'accueille avec la promesse d'expériences inoubliables et de rencontres qui marqueront ton destin.</p>
                    </div>
                </div>
            </div>

            <div class="mt-10 bg-gray-50 rounded-lg p-6 text-center">
                <h3 class="text-lg sm:text-xl font-medium mb-2">Prêt pour l'Aventure ?</h3>
                <p class="text-gray-600 text-sm sm:text-base">Peerkinton s'ouvre au monde, tout les ans pendant l'automne, l'hiver et le début de l'été.</p>
            </div>
        </section>

        <section class="py-12 sm:py-16">
            <div class="text-center mb-10">
                <h2 class="text-2xl sm:text-4xl font-medium mb-3">Questions Fréquentes</h2>
                <p class="text-gray-600 text-sm sm:text-base">Tout ce que tu dois savoir sur Peerkinton</p>
            </div>

            <div class="max-w-3xl mx-auto space-y-4">
                <div class="bg-gray-50 rounded-lg overflow-hidden">
                    <div class="faq-item p-5 flex justify-between items-center" onclick="toggleFaq(0)">
                        <h3 class="text-base sm:text-lg font-medium">Comment rejoindre Peerkinton ?</h3>
                        <svg class="faq-icon w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                    <div class="faq-answer px-5 pb-5">
                        <p class="text-gray-600 text-sm sm:text-base">Pour rejoindre Peerkinton, il te suffit de te connecter sur Minecraft avec l'adresse <span class="font-mono font-medium">play.peerkinton.com</span>. Le serveur est ouvert de Septembre à Juin chaque année. Rejoins également notre Discord pour rester informé des actualités et rencontrer la communauté.</p>
                    </div>
                </div>

                <div class="bg-gray-50 rounded-lg overflow-hidden">
                    <div class="faq-item p-5 flex justify-between items-center" onclick="toggleFaq(1)">
                        <h3 class="text-base sm:text-lg font-medium">Quelle version de Minecraft est requise ?</h3>
                        <svg class="faq-icon w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                    <div class="faq-answer px-5 pb-5">
                        <p class="text-gray-600 text-sm sm:text-base">Peerkinton fonctionne sur la dernière version stable de Minecraft Java Edition. Nous recommandons de toujours maintenir ton client à jour pour profiter pleinement de l'expérience et des nouvelles fonctionnalités du royaume.</p>
                    </div>
                </div>

                <div class="bg-gray-50 rounded-lg overflow-hidden">
                    <div class="faq-item p-5 flex justify-between items-center" onclick="toggleFaq(2)">
                        <h3 class="text-base sm:text-lg font-medium">Puis-je construire ma propre ville ?</h3>
                        <svg class="faq-icon w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                    <div class="faq-answer px-5 pb-5">
                        <p class="text-gray-600 text-sm sm:text-base">Absolument ! Le royaume encourage les citoyens ambitieux à fonder leurs propres villes. Tu devras respecter les lois du royaume, obtenir l'approbation du conseil et suivre les directives architecturales. Consulte notre wiki pour connaître les démarches précises.</p>
                    </div>
                </div>

                <div class="bg-gray-50 rounded-lg overflow-hidden">
                    <div class="faq-item p-5 flex justify-between items-center" onclick="toggleFaq(3)">
                        <h3 class="text-base sm:text-lg font-medium">Y a-t-il des règles à respecter ?</h3>
                        <svg class="faq-icon w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                    <div class="faq-answer px-5 pb-5">
                        <p class="text-gray-600 text-sm sm:text-base">Oui, le royaume dispose d'un système législatif complet accessible sur <a href="https://gov.peerkinton.com" class="text-blue-600 hover:underline">gov.peerkinton.com</a>. Ces lois garantissent une expérience harmonieuse pour tous. Le respect mutuel, la collaboration et l'élégance sont les piliers de notre communauté.</p>
                    </div>
                </div>

                <div class="bg-gray-50 rounded-lg overflow-hidden">
                    <div class="faq-item p-5 flex justify-between items-center" onclick="toggleFaq(4)">
                        <h3 class="text-base sm:text-lg font-medium">Comment obtenir un compte citoyen ?</h3>
                        <svg class="faq-icon w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                    <div class="faq-answer px-5 pb-5">
                        <p class="text-gray-600 text-sm sm:text-base">Le compte citoyen te permet d'accéder à des services exclusifs du royaume. Clique sur le bouton "Compte citoyen" dans le menu principal pour créer ton compte. Tu pourras ensuite gérer tes propriétés, consulter tes missions et interagir avec l'administration du royaume.</p>
                    </div>
                </div>

                <div class="bg-gray-50 rounded-lg overflow-hidden">
                    <div class="faq-item p-5 flex justify-between items-center" onclick="toggleFaq(5)">
                        <h3 class="text-base sm:text-lg font-medium">Quelle est la différence entre territoires membres et indépendants ?</h3>
                        <svg class="faq-icon w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                    <div class="faq-answer px-5 pb-5">
                        <p class="text-gray-600 text-sm sm:text-base">Les territoires membres font partie intégrante du Royaume de Peerkinton et suivent ses lois. Les territoires indépendants maintiennent leur propre gouvernance tout en coexistant pacifiquement avec le royaume. Les deux types de territoires peuvent commercer et collaborer ensemble.</p>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <footer class="border-t border-gray-200 mt-12">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 py-6">
            <div class="flex flex-col sm:flex-row justify-between items-start text-xs sm:text-sm text-gray-600 gap-4">
                <div>
                    <span>© 2025 Peerkinton - all right reserved by the aktascorp. This project is supported by Microsoft France. Peerkinton is a fictional world created in the Minecraft video game. Signs labelled "Government" or similar are not signs of a real country or republic.</span>
                </div>
                <div class="flex flex-col space-y-1">
                    <span>Create by the aktascorp</span>
                    <a href="https://aktascorp.com/privacy" class="hover:text-gray-900 transition-colors">Confidentiality</a>
                </div>
            </div>
        </div>
    </footer>

    <script>
        let serverIsOnline = true;
        let serverInMaintenance = false;

        function updateServerStatus() {
            const indicator = document.getElementById('statusIndicator');
            const statusValue = document.getElementById('statusValue');
            
            if (serverInMaintenance) {
                indicator.className = 'status-indicator status-maintenance';
                statusValue.textContent = 'Maintenance en cours !';
                statusValue.className = 'text-xs sm:text-sm font-medium text-yellow-600';
            } else if (serverIsOnline) {
                indicator.className = 'status-indicator status-open';
                statusValue.textContent = 'Bienvenue à vous !';
                statusValue.className = 'text-xs sm:text-sm font-medium text-green-600';
            } else {
                indicator.className = 'status-indicator status-closed';
                statusValue.textContent = 'Fermé ! On se voit le 10 Octobre !';
                statusValue.className = 'text-xs sm:text-sm font-medium text-red-600';
            }
        }

        function setServerStatus(isOnline, inMaintenance = false) {
            serverIsOnline = isOnline;
            serverInMaintenance = inMaintenance;
            updateServerStatus();
        }

        function toggleMobileMenu() {
            const menu = document.getElementById('mobileMenu');
            const hamburger = document.querySelector('.hamburger');
            
            menu.classList.toggle('show');
            hamburger.classList.toggle('active');
        }

        function copyAddress() {
            const address = document.getElementById('serverAddress').textContent;
            navigator.clipboard.writeText(address).then(() => {
                const button = event.target;
                const originalText = button.textContent;
                button.textContent = 'Copié !';
                button.classList.remove('bg-black', 'hover:bg-gray-800');
                button.classList.add('bg-green-600');
                
                setTimeout(() => {
                    button.textContent = originalText;
                    button.classList.remove('bg-green-600');
                    button.classList.add('bg-black', 'hover:bg-gray-800');
                }, 2000);
            });
        }

        function toggleFaq(index) {
            const faqItems = document.querySelectorAll('.faq-answer');
            const faqIcons = document.querySelectorAll('.faq-icon');
            
            faqItems[index].classList.toggle('active');
            faqIcons[index].classList.toggle('active');
        }

        updateServerStatus();
    </script>
</body>
</html>