<?php
session_start();
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#f5f5dc]">
    <div class="min-h-screen p-8">
        <div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-lg">
            <h1 class="text-2xl mb-6">Crer votre planning</h1>
            
            <form action="generate-pdf.php" method="POST">
                <div class="mb-4">
                    <label class="block mb-2">Nombre de semaines</label>
                    <input type="number" name="weeks" min="1" max="52" required 
                           class="w-full p-2 border rounded">
                </div>

                <div class="mb-4">
                    <label class="block mb-2">Type de priode</label>
                    <select name="period_type" class="w-full p-2 border rounded">
                        <option value="school">Priode scolaire</option>
                        <option value="holiday">Vacances</option>
                    </select>
                </div>

                <div class="mb-6">
                    <h3 class="text-lg mb-3">Planning journalier (sera rpt chaque semaine)</h3>
                    
                    <?php foreach(['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'] as $day): ?>
                    <div class="mb-4 p-4 border rounded">
                        <h4 class="font-bold mb-2"><?= $day ?></h4>
                        
                        <div class="mb-3">
                            <label class="block mb-1">Objectifs de la journe</label>
                            <textarea name="objectives[<?= strtolower($day) ?>]" 
                                      class="w-full p-2 border rounded" rows="3"></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="block mb-1">Tches importantes / Devoirs</label>
                            <textarea name="tasks[<?= strtolower($day) ?>]" 
                                      class="w-full p-2 border rounded" rows="2"></textarea>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <button type="submit" class="w-full bg-blue-500 text-white p-3 rounded">
                    Gnrer mon planning PDF
                </button>
            </form>
        </div>
    </div>
</body>
</html>