<!DOCTYPE html>
<html lang="en">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title>Privacy - AktasCorp</title>
   <link rel="icon" type="image/png" href="ac.png">
   <script src="https://cdn.tailwindcss.com"></script>
   <link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
   <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
   <style>
       body {
           font-family: 'Raleway', sans-serif;
           background-color: #f9f0e6;
       }
   </style>
</head>
<body class="text-gray-800">
   <div class="max-w-4xl mx-auto px-4 py-20">
       <header class="mb-24">
           <h1 class="text-4xl font-light tracking-wider">Privacy Policy</h1>
           <p class="text-sm">This document presents and is associated with the site where the link to this page was presented.</p>
           <p class="text-sm mt-2">Last updated: Sunday 17 August 2025 at 12:03PM (GMT+2)</p>
           <div class="text-left mt-2">
               <a href="/" class="text-sm text-gray-600 hover:text-gray-800">← Back to aktascorp</a>
           </div>
       </header>
       <main>       
           
           <section class="mb-2">
               <h2 class="text-2xl font-light mb-2">Data Collection</h2>
               <p class="mb-6">
                   We collect minimal data necessary to improve user experience across our partner sites. This includes basic analytics and essential cookies. The data is collected by the <a class="underline italic" href="https://umami.is/">Umami service</a>. The request for your data is not feasible because they are not stored in our services or in a really static way at Umami.
               </p>
               <h3 class="text-lg font-medium mb-4">Types of data collected:</h3>
               <ul class="space-y-2 mb-6">
                   <li>• IP address (for approximate location)</li>
                   <li>• Browser type and version</li>
                   <li>• Pages visited and time spent</li>
                   <li>• Referrer information</li>
                   <li>• Device type and screen resolution</li>
               </ul>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Information Usage</h2>
               <ul class="space-y-4">
                   <li>Analytics for site improvement</li>
                   <li>Essential functionality</li>
                   <li>Location (approximate based on your ip address. We only have data on where you visited the site)</li>
               </ul>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Legal Basis for Processing</h2>
               <p class="mb-6">
                   We process your data based on legitimate interest for analytics and website functionality. No consent is required for essential cookies and anonymous analytics.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Data Sharing</h2>
               <p class="mb-6">
                   We do not sell, trade, or share your personal data with third parties except for the Umami analytics service. All data remains anonymous and aggregated.
               </p>
               <p class="mb-6">
                   <strong>Exception for Vert Chasseur:</strong> Email addresses and names of Vert Chasseur users may be shared with verified local partner businesses for the sole purpose of sending relevant community communications and promotional offers.
               </p>
           </section>
           
           <section class="mb-12 bg-green-50 p-6 rounded-lg border border-green-200">
               <h2 class="text-2xl font-light mb-6 text-green-800">Vert Chasseur Project</h2>
               <p class="mb-6">
                   For users of the Vert Chasseur platform, additional data sharing and usage applies:
               </p>
               <h3 class="text-lg font-medium mb-4">Data Collection for Vert Chasseur:</h3>
               <ul class="space-y-2 mb-6">
                   <li>• Email address (for account creation and communications)</li>
                   <li>• First and last name (for personalization)</li>
                   <li>• Address information (for local services)</li>
                   <li>• Preferences and interaction data</li>
               </ul>
               <h3 class="text-lg font-medium mb-4">Partner Communications:</h3>
               <p class="mb-4">
                   By creating an account on Vert Chasseur, you consent to receive communications from our partner businesses, including:
               </p>
               <ul class="space-y-2 mb-6">
                   <li>• Email newsletters and promotional offers from local partner merchants</li>
                   <li>• Push notifications about local events, deals, and community updates</li>
                   <li>• Personalized recommendations based on your location and preferences</li>
               </ul>
               <p class="mb-4">
                   Your email address and name may be shared with verified partner businesses in the Vert Chasseur area for the purpose of sending relevant local communications.
               </p>
               <h3 class="text-lg font-medium mb-4">Managing Communications:</h3>
               <p class="mb-6">
                   You can opt-out of partner communications at any time by:
                   <br>• Using the unsubscribe link in any email
                   <br>• Adjusting notification settings in your account dashboard
                   <br>• Contacting us directly at msg@aktascorp.com
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Data Retention</h2>
               <p class="mb-6">
                   Analytics data is retained for a maximum of 24 months. After this period, data is automatically deleted from our systems.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Your Rights</h2>
               <p class="mb-4">Under applicable privacy laws, you have the right to:</p>
               <ul class="space-y-2 mb-6">
                   <li>• Access your personal data</li>
                   <li>• Rectify inaccurate data</li>
                   <li>• Request data deletion</li>
                   <li>• Object to data processing</li>
                   <li>• Data portability</li>
                   <li>• Withdraw consent</li>
               </ul>
               <p class="mb-6">
                   You can request information about you, across our website contacting msg@aktascorp.com
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Cookies</h2>
               <p class="mb-6">
                   We use essential cookies for website functionality and analytics cookies through Umami. These cookies do not track personal information and are anonymous.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">International Transfers</h2>
               <p class="mb-6">
                   Data may be processed outside your country of residence. We ensure appropriate safeguards are in place for any international data transfers.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Security</h2>
               <p class="mb-6">
                   We implement appropriate technical and organizational measures to protect your data against unauthorized access, alteration, disclosure, or destruction.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Children's Privacy</h2>
               <p class="mb-6">
                   Our services are not directed to children under 13. We do not knowingly collect personal information from children under 13.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Changes to This Policy</h2>
               <p class="mb-6">
                   We may update this privacy policy from time to time. Changes will be posted on this page with an updated revision date.
               </p>
           </section>
           
           <section class="mb-12">
               <h2 class="text-2xl font-light mb-6">Contact Information</h2>
               <p class="mb-6">
                   For any privacy-related questions or concerns, contact us at: msg@aktascorp.com
               </p>
           </section>
       </main>
       <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
           <p>&copy; 2025 AktasCorporation. All rights reserved.</p>
       </footer>
   </div>
</body>
</html>