<?php
header('Content-Type: application/json');
include 'db.php';

function formatSchedule() {
    $schedule = [];
    $hours = [];
    $dayNames = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
    $englishDays = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
    
    foreach ($dayNames as $index => $day) {
        if (!isset($_POST['closed_' . $day]) && !empty($_POST[$day . '_open']) && !empty($_POST[$day . '_close'])) {
            $schedule[] = $englishDays[$index];
            $hours[] = $_POST[$day . '_open'] . ' à ' . $_POST[$day . '_close'];
        }
    }
    
    return [
        'days' => implode(', ', $schedule),
        'hours' => implode(', ', array_unique($hours))
    ];
}

function uploadImage($file) {
    $uploadDir = 'uploads/';
    
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    
    $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/webp'];
    $maxFileSize = 5 * 1024 * 1024;
    
    if (!in_array($file['type'], $allowedTypes)) {
        throw new Exception('Type de fichier non autorisé. Utilisez JPG, PNG ou WebP.');
    }
    
    if ($file['size'] > $maxFileSize) {
        throw new Exception('Fichier trop volumineux. Taille maximale : 5MB.');
    }
    
    $fileExtension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $fileName = uniqid('commerce_') . '.' . $fileExtension;
    $filePath = $uploadDir . $fileName;
    
    if (!move_uploaded_file($file['tmp_name'], $filePath)) {
        throw new Exception('Erreur lors de l\'upload de l\'image');
    }
    
    return $filePath;
}

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Méthode non autorisée');
    }

    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $uber_eats = isset($_POST['uber_eats']) ? 1 : 0;
    $website_link = trim($_POST['website_link'] ?? '');
    $shop_phone = trim($_POST['shop_phone'] ?? '');
    $manager_phone = trim($_POST['manager_phone'] ?? '');
    $contact_email = trim($_POST['contact_email'] ?? '');
    $partner_consent = isset($_POST['partner_consent']) ? 1 : 0;

    if (empty($title) || empty($description) || empty($shop_phone) || empty($manager_phone) || empty($contact_email)) {
        throw new Exception('Tous les champs obligatoires doivent être remplis');
    }

    if (!filter_var($contact_email, FILTER_VALIDATE_EMAIL)) {
        throw new Exception('Email invalide');
    }

    if (!$partner_consent) {
        throw new Exception('Vous devez accepter le programme partenaire');
    }

    if (!isset($_FILES['cover_image']) || $_FILES['cover_image']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Image de couverture requise');
    }

    $imagePath = uploadImage($_FILES['cover_image']);
    $scheduleData = formatSchedule();
    
    $stmt = $conn->prepare("INSERT INTO commerce_submissions (
        title, description, url_image, uber_eats, website_link, 
        day_open, hour_open, shop_phone, manager_phone, contact_email,
        partner_consent, submission_date, status
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), 'pending')");
    
    $stmt->bind_param("sssissssssi", 
        $title, $description, $imagePath, $uber_eats, $website_link,
        $scheduleData['days'], $scheduleData['hours'], $shop_phone, $manager_phone, $contact_email, $partner_consent
    );

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Demande envoyée avec succès']);
    } else {
        if (file_exists($imagePath)) {
            unlink($imagePath);
        }
        throw new Exception('Erreur lors de l\'enregistrement');
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>