<?php
$selected_storage = $_POST['selected_storage'] ?? '';
$selected_server = $_POST['selected_server'] ?? '';
$selected_ram = $_POST['selected_ram'] ?? '';
$billing_period = $_POST['billing_period'] ?? 'monthly';
$total_price = $_POST['total_price'] ?? '0';

$additional_services = $_POST['additional_services'] ?? [];
$additional_services_text = !empty($additional_services) ? implode(', ', $additional_services) : 'None';

$company_name = $_POST['company_name'] ?? '';
$registration_number = $_POST['registration_number'] ?? '';
$company_address = $_POST['company_address'] ?? '';
$industry_sector = $_POST['industry_sector'] ?? '';

$contact_name = $_POST['contact_name'] ?? '';
$position = $_POST['position'] ?? '';
$email = $_POST['email'] ?? '';
$phone = $_POST['phone'] ?? '';
$project_description = $_POST['project_description'] ?? '';

$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: Imators Systems <no-reply@imators.com>" . "\r\n";

$admin_email = 'press@imators.com';
$admin_subject = "New Server Order - $company_name";

$admin_message = "
<html>
<head>
    <title>New Server Order</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #000; color: #fff; padding: 10px 20px; }
        .section { margin-bottom: 20px; }
        .section h2 { border-bottom: 1px solid #eee; padding-bottom: 5px; }
        .footer { font-size: 12px; color: #777; margin-top: 30px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>New Server Order to Install</h1>
        </div>
        
        <div class='section'>
            <h2>Server Configuration</h2>
            <p><strong>Storage:</strong> $selected_storage</p>
            <p><strong>Server Type:</strong> $selected_server</p>
            <p><strong>RAM:</strong> $selected_ram</p>
            <p><strong>Billing Period:</strong> " . ($billing_period === 'annual' ? 'Annual' : 'Monthly') . "</p>
            <p><strong>Total Price:</strong> €$total_price</p>
            <p><strong>Additional Services:</strong> $additional_services_text</p>
        </div>
        
        <div class='section'>
            <h2>Company Information</h2>
            <p><strong>Name:</strong> $company_name</p>
            <p><strong>Registration Number:</strong> $registration_number</p>
            <p><strong>Address:</strong> $company_address</p>
            <p><strong>Sector:</strong> $industry_sector</p>
        </div>
        
        <div class='section'>
            <h2>Contact</h2>
            <p><strong>Name:</strong> $contact_name</p>
            <p><strong>Position:</strong> $position</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Phone:</strong> $phone</p>
        </div>
        
        <div class='section'>
            <h2>Project Description</h2>
            <p>$project_description</p>
        </div>
        
        <div class='footer'>
            <p>This order requires installation. Please schedule the configuration and inform the client as soon as possible.</p>
        </div>
    </div>
</body>
</html>
";

$client_subject = "Your Imators Systems Order - Confirmation";

$client_message = "
<html>
<head>
    <title>Imators Systems Order Confirmation</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #000; color: #fff; padding: 10px 20px; }
        .section { margin-bottom: 20px; }
        .section h2 { border-bottom: 1px solid #eee; padding-bottom: 5px; }
        .footer { font-size: 12px; color: #777; margin-top: 30px; }
        .button { display: inline-block; background-color: #000; color: #fff; padding: 10px 20px; text-decoration: none; border-radius: 5px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>Thank you for your order, $contact_name</h1>
        </div>
        
        <div class='section'>
            <h2>Your Configuration</h2>
            <p>We have received your order for an Imators Systems server with the following configuration:</p>
            <ul>
                <li><strong>Storage:</strong> $selected_storage</li>
                <li><strong>Server Type:</strong> $selected_server</li>
                <li><strong>RAM:</strong> $selected_ram</li>
                <li><strong>Billing Period:</strong> " . ($billing_period === 'annual' ? 'Annual' : 'Monthly') . "</li>
                <li><strong>Total Price:</strong> €$total_price</li>
                <li><strong>Additional Services:</strong> $additional_services_text</li>
            </ul>
        </div>
        
        <div class='section'>
            <h2>Next Steps</h2>
            <p>Our technical team will now prepare your server according to your specifications. You will soon receive an invoice and server access details.</p>
            <p>Estimated setup time: <strong>24-48 business hours</strong>.</p>
        </div>
        
        <div class='section'>
            <h2>Technical Support</h2>
            <p>If you have any questions or need assistance, our support team is available 24/7 <a href="https://imators.com/supporr">at our ticket support systems</a></p>
        </div>
        
        <div class='footer'>
            <p>Imators LLC, all right reserved</p>
            <p>This is an automated message, please do not reply directly.</p>
        </div>
    </div>
</body>
</html>
";

$admin_mail_sent = mail($admin_email, $admin_subject, $admin_message, $headers);
$client_mail_sent = mail($email, $client_subject, $client_message, $headers);

try {
    $db_host = 'localhost'; 
    $db_name = 'imators_db';
    $db_user = 'db_user';
    $db_pass = 'db_password';
    
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $stmt = $pdo->prepare("
        INSERT INTO orders (
            company_name, registration_number, company_address, industry_sector,
            contact_name, position, email, phone, project_description,
            storage, server_type, ram, billing_period, total_price, additional_services,
            order_date, status
        ) VALUES (
            :company_name, :registration_number, :company_address, :industry_sector,
            :contact_name, :position, :email, :phone, :project_description,
            :storage, :server_type, :ram, :billing_period, :total_price, :additional_services,
            NOW(), 'pending'
        )
    ");
    
    $stmt->execute([
        'company_name' => $company_name,
        'registration_number' => $registration_number,
        'company_address' => $company_address,
        'industry_sector' => $industry_sector,
        'contact_name' => $contact_name,
        'position' => $position,
        'email' => $email,
        'phone' => $phone,
        'project_description' => $project_description,
        'storage' => $selected_storage,
        'server_type' => $selected_server,
        'ram' => $selected_ram,
        'billing_period' => $billing_period,
        'total_price' => $total_price,
        'additional_services' => $additional_services_text
    ]);
    
    $order_id = $pdo->lastInsertId();
    
    $stmt = $pdo->prepare("
        INSERT INTO invoices (
            order_id, company_name, amount, status, created_at, due_date
        ) VALUES (
            :order_id, :company_name, :amount, 'pending', NOW(), DATE_ADD(NOW(), INTERVAL 7 DAY)
        )
    ");
    
    $stmt->execute([
        'order_id' => $order_id,
        'company_name' => $company_name,
        'amount' => $total_price
    ]);
    
    $db_success = true;
} catch (PDOException $e) {
    $db_success = false;
    $db_error = $e->getMessage();
    
    $error_message = "Database error when saving order for $company_name: " . $db_error;
    mail($admin_email, "DB ERROR - New order", $error_message, $headers);
}

if ($admin_mail_sent && $client_mail_sent) {
    header("Location: thankyou.php?order=success");
    exit();
} else {
    header("Location: error.php?msg=mail_error");
    exit();
}
?>