<?php
session_start();
$users = json_decode(file_get_contents('data/users.json'), true);
$user = $users[$_SESSION['user_id']];
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#f5f5dc]">
    <div class="min-h-screen p-8">
        <div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-lg">
            <h1 class="text-3xl font-bold mb-2">
                Bonjour <?= htmlspecialchars($user['name']) ?>
            </h1>
            <div class="text-xl text-gray-600" id="datetime"></div>
            <a href="planner.php" class="mt-4 inline-block bg-blue-500 text-white p-2 rounded">
                Crer un planning
            </a>
        </div>
    </div>

    <script>
    function updateDateTime() {
        const now = new Date();
        const options = { 
            weekday: 'long', 
            year: 'numeric', 
            month: 'long', 
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
        };
        document.getElementById('datetime').textContent = 
            now.toLocaleDateString('fr-FR', options);
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
    </script>
</body>
</html>