<?php
function save_program($data) {
    $filename = 'program_' . date('Y-m-d_His') . '.pdf';
    
    // Sauvegarder aussi les données brutes en JSON
    $json_data = json_encode($data);
    file_put_contents(__DIR__ . '/programs/data_' . $filename . '.json', $json_data);
    
    return $filename;
}

function generate_time_slots($start, $end, $interval) {
    $slots = [];
    $current = strtotime($start);
    $end = strtotime($end);
    
    while ($current <= $end) {
        $slots[] = date('H:i', $current);
        $current = strtotime("+{$interval} minutes", $current);
    }
    
    return $slots;
}