<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['merchant_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

require_once '../config/db_comm.php';
require_once '../config/db.php';

$merchant_id = $_SESSION['merchant_id'];
$subject = trim($_POST['subject'] ?? '');
$content = trim($_POST['content'] ?? '');

if (empty($subject) || empty($content)) {
    echo json_encode(['success' => false, 'message' => 'Sujet et contenu requis']);
    exit();
}

try {
    $stmt = $pdo_comm->prepare("SELECT setting_value FROM settings WHERE setting_key IN ('email_limit_daily', 'email_cooldown_hours', 'start_hour', 'end_hour')");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    $current_hour = (int)date('H');
    if ($current_hour < $settings['start_hour'] || $current_hour >= $settings['end_hour']) {
        echo json_encode(['success' => false, 'message' => 'Emails autorisés de 7h à 22h uniquement']);
        exit();
    }
    
    $today = date('Y-m-d');
    $stmt = $pdo_comm->prepare("SELECT COUNT(*) FROM emails_log WHERE merchant_id = ? AND DATE(sent_at) = ?");
    $stmt->execute([$merchant_id, $today]);
    $sent_today = $stmt->fetchColumn();
    
    if ($sent_today >= $settings['email_limit_daily']) {
        echo json_encode(['success' => false, 'message' => 'Limite quotidienne atteinte (2 emails/jour)']);
        exit();
    }
    
    $stmt = $pdo_comm->prepare("SELECT sent_at FROM emails_log WHERE merchant_id = ? AND DATE(sent_at) = ? ORDER BY sent_at DESC LIMIT 1");
    $stmt->execute([$merchant_id, $today]);
    $last_email = $stmt->fetchColumn();
    
    if ($last_email) {
        $cooldown_minutes = $settings['email_cooldown_hours'] * 60;
        $time_diff = (time() - strtotime($last_email)) / 60;
        
        if ($time_diff < $cooldown_minutes) {
            $remaining = ceil($cooldown_minutes - $time_diff);
            echo json_encode(['success' => false, 'message' => "Cooldown actif. Prochain email dans {$remaining} minutes"]);
            exit();
        }
    }
    
    $stmt = $pdo->prepare("SELECT email FROM residents WHERE email IS NOT NULL AND email != ''");
    $stmt->execute();
    $recipients = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($recipients)) {
        echo json_encode(['success' => false, 'message' => 'Aucun destinataire trouvé']);
        exit();
    }
    
    $headers = [
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=UTF-8',
        'From: noreply@aktascorp.com',
        'Reply-To: support@aktascorp.com'
    ];
    
    $email_content = "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='UTF-8'>
        <style>
            body { font-family: 'Poppins', Arial, sans-serif; font-weight: 300; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { text-align: center; margin-bottom: 30px; }
            .content { background: #f9f9f9; padding: 30px; border-radius: 8px; }
            .footer { text-align: center; margin-top: 30px; font-size: 12px; color: #666; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>aktascorp</h1>
            </div>
            <div class='content'>
                <h2>{$subject}</h2>
                <p>" . nl2br(htmlspecialchars($content)) . "</p>
            </div>
            <div class='footer'>
                <p>© 2025 aktascorp. Tous droits réservés.</p>
                <p>Email promotionnel envoyé via Comm Access</p>
            </div>
        </div>
    </body>
    </html>";
    
    $success_count = 0;
    foreach ($recipients as $email) {
        if (mail($email, $subject, $email_content, implode("\r\n", $headers))) {
            $success_count++;
        }
    }
    
    if ($success_count > 0) {
        $stmt = $pdo_comm->prepare("INSERT INTO emails_log (merchant_id, subject, content) VALUES (?, ?, ?)");
        $stmt->execute([$merchant_id, $subject, $content]);
        
        echo json_encode(['success' => true, 'message' => "Email envoyé à {$success_count} destinataires"]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'envoi des emails']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur']);
}
?>