<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['merchant_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

require_once '../config/db_comm.php';
require_once '../config/onesignal.php';

$merchant_id = $_SESSION['merchant_id'];
$message = trim($_POST['message'] ?? '');
$platform = 'both';

if (empty($message)) {
    echo json_encode(['success' => false, 'message' => 'Message requis']);
    exit();
}

try {
    $stmt = $pdo_comm->prepare("SELECT setting_value FROM settings WHERE setting_key IN ('notification_limit_daily', 'start_hour', 'end_hour')");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    $current_hour = (int)date('H');
    if ($current_hour < $settings['start_hour'] || $current_hour >= $settings['end_hour']) {
        echo json_encode(['success' => false, 'message' => 'Notifications autorisées de 7h à 22h uniquement']);
        exit();
    }
    
    $today = date('Y-m-d');
    $stmt = $pdo_comm->prepare("SELECT COUNT(*) FROM notifications_log WHERE merchant_id = ? AND DATE(sent_at) = ?");
    $stmt->execute([$merchant_id, $today]);
    $sent_today = $stmt->fetchColumn();
    
    if ($sent_today >= $settings['notification_limit_daily']) {
        echo json_encode(['success' => false, 'message' => 'Limite quotidienne atteinte (4 notifications/jour)']);
        exit();
    }
    
    $result = sendPushNotification($message, $platform);
    
    if ($result && isset($result['id'])) {
        $stmt = $pdo_comm->prepare("INSERT INTO notifications_log (merchant_id, message, platform) VALUES (?, ?, ?)");
        $stmt->execute([$merchant_id, $message, $platform]);
        
        echo json_encode(['success' => true, 'message' => 'Notification envoyée avec succès']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'envoi de la notification']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur']);
}
?>