<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$data = json_decode(file_get_contents('php://input'), true);

$userId = $data['userId'];
$title = $data['title'];
$message = $data['message'];
$notifData = isset($data['data']) ? $data['data'] : [];

$fields = [
    'app_id' => 'TON_ONESIGNAL_APP_ID',
    'include_aliases' => [
        'external_id' => [$userId]
    ],
    'target_channel' => 'push',
    'headings' => ['en' => $title],
    'contents' => ['en' => $message],
    'data' => $notifData
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.onesignal.com/notifications');
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Basic TON_ONESIGNAL_REST_API_KEY'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

$response = curl_exec($ch);
curl_close($ch);

echo $response;
?>