<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title>Simulation Réseau Social</title>
   <script src="https://cdn.tailwindcss.com"></script>
   <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
</head>
<body class="bg-white">
   <div id="disclaimer" class="fixed inset-0 bg-white z-50 flex items-center justify-center">
       <div class="max-w-2xl mx-auto p-8 text-center">
           <h1 class="text-3xl font-bold mb-6">Simulation Réseau Social</h1>
           <p class="text-gray-600 mb-8 leading-relaxed">
               Cette expérience simule comment les réseaux sociaux collectent et analysent tes données. 
               Navigue, interagis et observe comment l'algorithme apprend de tes actions.
           </p>
           <div class="flex items-center justify-center mb-8">
               <input type="checkbox" id="accept" class="mr-3 scale-125">
               <label for="accept" class="text-sm">J'accepte de participer à cette simulation éducative</label>
           </div>
           <button id="start" class="bg-black text-white px-8 py-3 rounded-lg opacity-50 cursor-not-allowed" disabled>
               Commencer l'expérience
           </button>
       </div>
   </div>

   <div id="app" class="hidden min-h-screen flex">
       <div class="w-80 bg-gray-50 p-6 border-r">
           <div class="text-center mb-8">
               <div class="w-20 h-20 bg-gray-300 rounded-full mx-auto mb-4 overflow-hidden">
                   <img id="profilePic" src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='80' height='80' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2'%3E%3C/path%3E%3Ccircle cx='12' cy='7' r='4'%3E%3C/circle%3E%3C/svg%3E" class="w-full h-full object-cover">
               </div>
               <input type="file" id="picUpload" accept="image/*" class="hidden">
               <button onclick="document.getElementById('picUpload').click()" class="text-sm text-blue-500 mb-4">Changer la photo</button>
           </div>
           
           <div class="space-y-4">
               <div>
                   <label class="block text-sm font-medium mb-2">Prénom</label>
                   <input id="firstName" type="text" value="Alex" class="w-full p-2 border rounded-lg">
               </div>
               <div>
                   <label class="block text-sm font-medium mb-2">Nom</label>
                   <input id="lastName" type="text" value="Martin" class="w-full p-2 border rounded-lg">
               </div>
               <div>
                   <label class="block text-sm font-medium mb-2">Âge</label>
                   <input id="age" type="number" value="25" class="w-full p-2 border rounded-lg">
               </div>
               <div>
                   <label class="block text-sm font-medium mb-2">Ville</label>
                   <input id="city" type="text" value="Paris" class="w-full p-2 border rounded-lg">
               </div>
           </div>

           <div class="mt-8">
               <h3 class="font-semibold mb-4">Statistiques</h3>
               <div class="space-y-2 text-sm">
                   <div class="flex justify-between">
                       <span>Posts vus:</span>
                       <span id="postsViewed">0</span>
                   </div>
                   <div class="flex justify-between">
                       <span>Likes donnés:</span>
                       <span id="likesGiven">0</span>
                   </div>
                   <div class="flex justify-between">
                       <span>Commentaires:</span>
                       <span id="commentsGiven">0</span>
                   </div>
               </div>
           </div>
       </div>

       <div class="flex-1 bg-white relative">
           <div class="w-full max-w-md mx-auto">
               <div class="bg-white border-x border-b rounded-b-3xl shadow-lg mx-4 mt-4" style="height: calc(100vh - 2rem);">
                   <div class="bg-gray-900 text-white p-4 rounded-t-3xl flex items-center justify-between">
                       <div class="flex items-center space-x-2">
                           <div class="w-2 h-2 bg-green-400 rounded-full"></div>
                           <span class="text-sm">SocialSim</span>
                       </div>
                       <div class="text-xs">14:32</div>
                   </div>
                   
                   <div id="feed" class="h-full overflow-y-auto pb-20">
                       <div class="p-4 space-y-6" id="postsContainer">
                       </div>
                   </div>
               </div>
           </div>
       </div>

       <div class="w-80 bg-gray-50 p-6 border-l">
           <h3 class="font-semibold mb-4">Analyse Algorithmique</h3>
           <div id="insights" class="space-y-4 text-sm">
               <div class="bg-blue-50 p-3 rounded-lg">
                   <strong>Démarrage de l'analyse...</strong>
                   <p class="mt-1">L'algorithme commence à observer tes interactions.</p>
               </div>
           </div>
       </div>
   </div>

   <script>
       let API_KEY = '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';

       let stats = {
           postsViewed: 0,
           likesGiven: 0,
           commentsGiven: 0
       };

       let userProfile = {
           firstName: 'Alex',
           lastName: 'Martin',
           age: 25,
           city: 'Paris'
       };

       let interactions = [];
       let currentPosts = [];

       const postTemplates = [
           { image: 'https://images.unsplash.com/photo-1514888286974-6c03e2ca1dba?w=400', content: 'Mon petit chat adoré ❤️', category: 'animals' },
           { image: 'https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=400', content: 'Délicieux repas italien 🍝', category: 'food' },
           { image: 'https://images.unsplash.com/photo-1441974231531-c6227db76b6e?w=400', content: 'Randonnée en montagne 🏔️', category: 'nature' },
           { image: 'https://images.unsplash.com/photo-1552053831-71594a27632d?w=400', content: 'Session sport du matin 💪', category: 'sport' },
           { image: 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=400', content: 'Nouvelle coiffure, qu en pensez-vous ?', category: 'lifestyle' },
           { image: 'https://images.unsplash.com/photo-1415604934674-561df9abf539?w=400', content: 'Coucher de soleil magique 🌅', category: 'nature' },
           { image: 'https://images.unsplash.com/photo-1574144611937-0df059b5ef3e?w=400', content: 'Mes chatons jouent ensemble 🐱', category: 'animals' },
           { image: 'https://images.unsplash.com/photo-1565299624946-b28f40a0ca4b?w=400', content: 'Pizza maison réussie ! 🍕', category: 'food' },
           { image: 'https://images.unsplash.com/photo-1517849845537-4d257902454a?w=400', content: 'Mon chien adore les promenades 🐕', category: 'animals' },
           { image: 'https://images.unsplash.com/photo-1555939594-58d7cb561ad1?w=400', content: 'Burger fait maison 🍔', category: 'food' },
           { image: 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=400', content: 'Vue imprenable sur la mer 🌊', category: 'nature' },
           { image: 'https://images.unsplash.com/photo-1571019613454-1cb2f99b2d8b?w=400', content: 'Séance gym intensive 🏋️', category: 'sport' },
           { image: 'https://images.unsplash.com/photo-1516575150278-77136aed6920?w=400', content: 'Nouveau look automne 🍂', category: 'lifestyle' },
           { image: 'https://images.unsplash.com/photo-1472214103451-9374bd1c798e?w=400', content: 'Forêt mystérieuse 🌲', category: 'nature' },
           { image: 'https://images.unsplash.com/photo-1601758228041-f3b2795255f1?w=400', content: 'Adopté ce petit ange 😻', category: 'animals' },
           { image: 'https://images.unsplash.com/photo-1567620905732-2d1ec7ab7445?w=400', content: 'Pancakes du dimanche 🥞', category: 'food' }
       ];

       const authors = ['Marie L.', 'Pierre K.', 'Sophie M.', 'Lucas R.', 'Emma T.', 'Thomas B.', 'Léa D.', 'Antoine F.', 'Julie C.', 'Marc P.', 'Camille V.', 'Alex M.', 'Sarah B.', 'David L.', 'Nina R.'];

       let postId = 1;

       document.getElementById('accept').addEventListener('change', function() {
           const startBtn = document.getElementById('start');
           if (this.checked) {
               startBtn.disabled = false;
               startBtn.classList.remove('opacity-50', 'cursor-not-allowed');
               startBtn.classList.add('hover:bg-gray-800', 'cursor-pointer');
           } else {
               startBtn.disabled = true;
               startBtn.classList.add('opacity-50', 'cursor-not-allowed');
               startBtn.classList.remove('hover:bg-gray-800', 'cursor-pointer');
           }
       });

       document.getElementById('start').addEventListener('click', function() {
           if (!document.getElementById('accept').checked) return;
           
           document.getElementById('disclaimer').classList.add('hidden');
           document.getElementById('app').classList.remove('hidden');
           loadInitialPosts();
           startAnalysis();
       });

       document.getElementById('picUpload').addEventListener('change', function(e) {
           if (e.target.files[0]) {
               const reader = new FileReader();
               reader.onload = function(e) {
                   document.getElementById('profilePic').src = e.target.result;
               };
               reader.readAsDataURL(e.target.files[0]);
           }
       });

       ['firstName', 'lastName', 'age', 'city'].forEach(field => {
           document.getElementById(field).addEventListener('input', function() {
               userProfile[field] = this.value;
           });
       });

       function generateRandomPost() {
           const template = postTemplates[Math.floor(Math.random() * postTemplates.length)];
           const author = authors[Math.floor(Math.random() * authors.length)];
           
           return {
               id: postId++,
               image: template.image,
               author: author,
               content: template.content,
               category: template.category
           };
       }

       function loadInitialPosts() {
           const container = document.getElementById('postsContainer');
           
           for (let i = 0; i < 5; i++) {
               createPost(generateRandomPost());
           }
       }

       function createPost(postData) {
           const container = document.getElementById('postsContainer');
           const post = document.createElement('div');
           post.className = 'bg-white border rounded-lg overflow-hidden';
           post.innerHTML = `
               <div class="p-3 flex items-center space-x-3">
                   <div class="w-8 h-8 bg-gray-300 rounded-full"></div>
                   <div>
                       <div class="font-semibold text-sm">${postData.author}</div>
                       <div class="text-xs text-gray-500">Il y a ${Math.floor(Math.random() * 12) + 1}h</div>
                   </div>
               </div>
               <img src="${postData.image}" class="w-full h-64 object-cover">
               <div class="p-3">
                   <div class="flex items-center space-x-4 mb-2">
                       <button class="like-btn flex items-center space-x-1 text-gray-600 hover:text-red-500">
                           <i data-lucide="heart" class="w-5 h-5"></i>
                           <span>${Math.floor(Math.random() * 200) + 10}</span>
                       </button>
                       <button class="comment-btn flex items-center space-x-1 text-gray-600 hover:text-blue-500">
                           <i data-lucide="message-circle" class="w-5 h-5"></i>
                           <span>${Math.floor(Math.random() * 50) + 1}</span>
                       </button>
                       <button class="hide-btn text-gray-400 hover:text-gray-600 ml-auto">
                           <i data-lucide="eye-off" class="w-5 h-5"></i>
                       </button>
                   </div>
                   <p class="text-sm">${postData.content}</p>
               </div>
           `;

           container.appendChild(post);
           currentPosts.push(postData);
           
           lucide.createIcons();
           
           stats.postsViewed++;
           updateStats();
           
           recordInteraction('view', postData);

           post.querySelector('.like-btn').addEventListener('click', function() {
               this.classList.toggle('text-red-500');
               this.querySelector('i').classList.toggle('fill-current');
               stats.likesGiven++;
               updateStats();
               recordInteraction('like', postData);
               analyzeInteraction('like', postData);
           });

           post.querySelector('.comment-btn').addEventListener('click', function() {
               const comment = prompt('Ton commentaire:');
               if (comment) {
                   stats.commentsGiven++;
                   updateStats();
                   recordInteraction('comment', postData, comment);
                   analyzeInteraction('comment', postData, comment);
               }
           });

           post.querySelector('.hide-btn').addEventListener('click', function() {
               post.style.display = 'none';
               recordInteraction('hide', postData);
               analyzeInteraction('hide', postData);
           });
       }

       function updateStats() {
           document.getElementById('postsViewed').textContent = stats.postsViewed;
           document.getElementById('likesGiven').textContent = stats.likesGiven;
           document.getElementById('commentsGiven').textContent = stats.commentsGiven;
       }

       function recordInteraction(type, post, data = null) {
           interactions.push({
               type,
               post,
               data,
               timestamp: Date.now()
           });
       }

       async function analyzeInteraction(type, post, data = null) {
           const insights = document.getElementById('insights');
           
           try {
               const response = await fetch("https://api.anthropic.com/v1/messages", {
                   method: "POST",
                   headers: {
                       "Content-Type": "application/json",
                       "x-api-key": API_KEY,
                       "anthropic-version": "2023-06-01"
                   },
                   body: JSON.stringify({
                       model: "claude-sonnet-4-20250514",
                       max_tokens: 200,
                       messages: [{
                           role: "user",
                           content: `Analyse cette interaction sur un réseau social et génère un insight algorithmique réaliste et court.

Profil utilisateur: ${userProfile.firstName} ${userProfile.lastName}, ${userProfile.age} ans, ${userProfile.city}
Action: ${type}
Post: "${post.content}" (catégorie: ${post.category})
${data ? `Données supplémentaires: ${data}` : ''}
Historique des interactions: ${interactions.slice(-5).map(i => `${i.type} sur ${i.post.category}`).join(', ')}

Réponds uniquement avec un insight court et réaliste de ce que l'algorithme pourrait déduire, style: "L'algorithme détecte que tu apprécies les contenus sur les animaux car tu as liké 2 posts de chats"`
                       }]
                   })
               });

               if (response.ok) {
                   const result = await response.json();
                   const insight = result.content[0].text;
                   
                   const insightDiv = document.createElement('div');
                   insightDiv.className = 'bg-yellow-50 p-3 rounded-lg';
                   insightDiv.innerHTML = `<strong>Analyse:</strong><p class="mt-1">${insight}</p>`;
                   
                   insights.appendChild(insightDiv);
                   insights.scrollTop = insights.scrollHeight;
               } else {
                   addGenericInsight(type, post);
               }
           } catch (error) {
               addGenericInsight(type, post);
           }
       }

       function addGenericInsight(type, post) {
           const insights = document.getElementById('insights');
           let message = '';
           
           switch(type) {
               case 'like':
                   message = `L'algorithme note que tu apprécies les contenus de type "${post.category}"`;
                   break;
               case 'comment':
                   message = `L'algorithme renforce son analyse: tu es actif sur les posts "${post.category}"`;
                   break;
               case 'hide':
                   message = `L'algorithme apprend que tu n'aimes pas ce type de contenu`;
                   break;
           }
           
           const insightDiv = document.createElement('div');
           insightDiv.className = 'bg-gray-50 p-3 rounded-lg';
           insightDiv.innerHTML = `<strong>Analyse:</strong><p class="mt-1">${message}</p>`;
           
           insights.appendChild(insightDiv);
       }

       function startAnalysis() {
           setTimeout(() => {
               const insights = document.getElementById('insights');
               const initialInsight = document.createElement('div');
               initialInsight.className = 'bg-green-50 p-3 rounded-lg';
               initialInsight.innerHTML = `<strong>Profil créé:</strong><p class="mt-1">L'algorithme a enregistré tes informations: ${userProfile.firstName}, ${userProfile.age} ans, ${userProfile.city}</p>`;
               insights.appendChild(initialInsight);
           }, 2000);
       }

       document.getElementById('feed').addEventListener('scroll', function() {
           if (this.scrollTop + this.clientHeight >= this.scrollHeight - 200) {
               for (let i = 0; i < 3; i++) {
                   createPost(generateRandomPost());
               }
           }
       });
   </script>
</body>
</html>