<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

require_once 'db.php';

$nom = htmlspecialchars($_POST['nom'] ?? '');
$prenom = htmlspecialchars($_POST['prenom'] ?? '');
$telephone = htmlspecialchars($_POST['telephone'] ?? '');
$email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);

$enfant = isset($_POST['enfant']) ? 1 : 0;
$nombre_enfants = htmlspecialchars($_POST['nombre_enfants'] ?? '');
$nom_enfants = htmlspecialchars($_POST['nom_enfants'] ?? '');

$conjoint = isset($_POST['conjoint']) ? 1 : 0;
$nom_conjoint = htmlspecialchars($_POST['nom_conjoint'] ?? '');
$prenom_conjoint = htmlspecialchars($_POST['prenom_conjoint'] ?? '');

$parking = isset($_POST['parking']) ? 1 : 0;
$type_vehicule = htmlspecialchars($_POST['type_vehicule'] ?? '');

$preferences_alimentaires = htmlspecialchars($_POST['preferences_alimentaires'] ?? '');

$cadeau = isset($_POST['cadeau']) ? 1 : 0;
$montant_cadeau = htmlspecialchars($_POST['montant_cadeau'] ?? '');
$montant_personnalise = isset($_POST['montant_personnalise']) && is_numeric($_POST['montant_personnalise']) ? intval($_POST['montant_personnalise']) : null;

$promo = isset($_POST['promo']) ? 1 : 0;
$donnees = isset($_POST['donnees']) ? 1 : 0;

if (!$donnees || empty($nom) || empty($prenom) || empty($telephone) || empty($email)) {
    header('Location: index.php?error=missing_fields');
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    header('Location: index.php?error=invalid_email');
    exit;
}

try {
    $check = $pdo->prepare("SELECT id FROM inscriptions WHERE email = ?");
    $check->execute([$email]);
    
    if ($check->rowCount() > 0) {
        header('Location: index.php?error=duplicate_email');
        exit;
    }

    $id = uniqid('ASD_', true);
    
    $stmt = $pdo->prepare("
        INSERT INTO inscriptions (
            id, nom, prenom, telephone, email, enfant, nombre_enfants, nom_enfants,
            conjoint, nom_conjoint, prenom_conjoint, parking, type_vehicule,
            preferences_alimentaires, cadeau, montant_cadeau, montant_personnalise,
            promo, date_inscription, ip_address
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)
    ");
    
    $stmt->execute([
        $id, $nom, $prenom, $telephone, $email, $enfant, $nombre_enfants, $nom_enfants,
        $conjoint, $nom_conjoint, $prenom_conjoint, $parking, $type_vehicule,
        $preferences_alimentaires, $cadeau, $montant_cadeau, $montant_personnalise,
        $promo, $_SERVER['REMOTE_ADDR'] ?? 'unknown'
    ]);
    
    $_SESSION['registration_data'] = [
        'id' => $id,
        'nom' => $nom,
        'prenom' => $prenom,
        'telephone' => $telephone,
        'email' => $email,
        'enfant' => $enfant,
        'nombre_enfants' => $nombre_enfants,
        'nom_enfants' => $nom_enfants,
        'conjoint' => $conjoint,
        'nom_conjoint' => $nom_conjoint,
        'prenom_conjoint' => $prenom_conjoint,
        'parking' => $parking,
        'type_vehicule' => $type_vehicule,
        'preferences_alimentaires' => $preferences_alimentaires,
        'cadeau' => $cadeau,
        'montant_cadeau' => $montant_cadeau,
        'montant_personnalise' => $montant_personnalise
    ];
    
    if ($cadeau) {
        header('Location: checkout.php');
    } else {
        header('Location: success.php');
    }
    exit;
    
} catch (PDOException $e) {
    error_log('Erreur inscription: ' . $e->getMessage());
    header('Location: index.php?error=database_error');
    exit;
}
?>