<?php
session_start();
include 'db.php';
require_once 'vendor/autoload.php';

\Stripe\Stripe::setApiKey('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');

if (!isset($_GET['session_id'])) {
    header('Location: dashboard.php');
    exit;
}

$session_id = $_GET['session_id'];

try {
    $session = \Stripe\Checkout\Session::retrieve($session_id);
    
    if ($session->payment_status == 'paid') {
        $resident_id = $session->client_reference_id;
        
        $subscription = \Stripe\Subscription::retrieve($session->subscription);
        
        $update_stmt = $conn->prepare("UPDATE residents SET member_ = 1, stripe_customer_id = ?, stripe_subscription_id = ?, subscription_start_date = NOW() WHERE id = ?");
        $update_stmt->bind_param("ssi", $session->customer, $session->subscription, $resident_id);
        $update_stmt->execute();
    }
} catch (Exception $e) {
    header('Location: dashboard.php?error=payment');
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paiement réussi - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gradient-to-br from-green-50 to-emerald-50 min-h-screen flex items-center justify-center p-4">
    <div class="max-w-md w-full bg-white rounded-2xl shadow-xl p-8 text-center">
        <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
            <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
        </div>
        
        <h1 class="text-2xl font-bold text-gray-900 mb-4">Félicitations !</h1>
        <p class="text-gray-600 mb-8">Tu es maintenant membre Vert Chasseur. Ta carte est prête à être utilisée !</p>
        
        <a href="resident-dashboard.php" class="block w-full bg-green-600 hover:bg-green-700 text-white font-medium py-3 px-4 rounded-lg transition-colors">
            Accéder à ma carte
        </a>
        
        <p class="text-xs text-gray-500 mt-6">Tu recevras un email de confirmation avec les détails de ton abonnement.</p>
    </div>
</body>
</html>