<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - AktasCorp</title>
    <meta name="description" content="Get support for AktasCorp products and services">
    <meta property="og:url" content="https://aktascorp.com/support">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Support - AktasCorp">
    <meta property="og:description" content="Get support for AktasCorp products and services">
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">

<div class="mt-16 max-w-4xl mx-auto px-4 py-5">
    <div class="relative rounded-lg overflow-hidden mb-12 h-64">
        <div class="absolute inset-0 bg-opacity-30"></div>
        <div class="absolute left-8 top-1/2 transform -translate-y-1/2 text-black">
            <h1 class="text-4xl font-light tracking-wider">Support Center</h1>
            <p class="text-sm">get help with aktascorp products</p>
            <div class="text-left mt-2">
                <a href="/" class="text-sm text-gray-600 hover:text-gray-800">← Back to aktascorp</a>
            </div>
        </div>
    </div>

    <main>
        <section class="mb-12">
            <h2 class="text-3xl mb-8">How can we help you?</h2>
            
            <div class="grid md:grid-cols-2 gap-8 mb-12">
                <div class="bg-white p-6 rounded-lg shadow-sm">
                    <h3 class="text-xl font-medium mb-4">Contact Support</h3>
                    <p class="text-gray-600 mb-4">Need direct assistance? Our support team is here to help.</p>
                    <div class="space-y-2">
                        <p><strong>Email:</strong> <a href="mailto:msg@aktascorp.com" class="text-gray-700 hover:text-gray-900">msg@aktascorp.com</a></p>
                        <p><strong>Response time:</strong> Within 24 hours</p>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-sm">
                    <h3 class="text-xl font-medium mb-4">Cantesso Academy</h3>
                    <p class="text-gray-600 mb-4">Questions about our young developers academy?</p>
                    <div class="space-y-2">
                        <p><a href="/cantesso" class="text-gray-700 hover:text-gray-900">Application Portal</a></p>
                        <p><strong>Academy Support:</strong> <a href="mailto:academy@aktascorp.com" class="text-gray-700 hover:text-gray-900">academy@aktascorp.com</a></p>
                    </div>
                </div>
            </div>

            <div class="bg-white p-8 rounded-lg shadow-sm mb-12">
                <h3 class="text-2xl font-medium mb-6">Frequently Asked Questions</h3>
                
                <div class="space-y-6">
                    <div>
                        <h4 class="text-lg font-medium mb-2">What is Cantesso Academy?</h4>
                        <p class="text-gray-700">Cantesso Academy is our young developers program designed to nurture the next generation of technology innovators. We accept students aged 13 and above who are passionate about coding and technology.</p>
                    </div>

                    <div>
                        <h4 class="text-lg font-medium mb-2">How do I apply to Cantesso Academy?</h4>
                        <p class="text-gray-700">You can apply through our <a href="/cantesso" class="text-gray-600 hover:text-gray-800 underline">application portal</a>. Simply fill out the form with your details and submit your application. We'll review it and get back to you within 5 business days.</p>
                    </div>

                    <div>
                        <h4 class="text-lg font-medium mb-2">What services does AktasCorp provide?</h4>
                        <p class="text-gray-700">AktasCorp specializes in software development, mobile applications, and technology education through our Cantesso Academy program. We focus on creating innovative solutions and fostering young talent.</p>
                    </div>

                    <div>
                        <h4 class="text-lg font-medium mb-2">How can I contact AktasCorp for business inquiries?</h4>
                        <p class="text-gray-700">For business partnerships, project inquiries, or general questions, please email us at <a href="mailto:msg@aktascorp.com" class="text-gray-600 hover:text-gray-800 underline">msg@aktascorp.com</a>. Include details about your project or inquiry for a faster response.</p>
                    </div>

                    <div>
                        <h4 class="text-lg font-medium mb-2">Where is AktasCorp located?</h4>
                        <p class="text-gray-700">AktasCorp is a company registered in the United States. We operate primarily online and serve clients globally.</p>
                    </div>
                </div>
            </div>

            <div class="bg-gray-100 p-6 rounded-lg">
                <h3 class="text-xl font-medium mb-4">Submit a Support Request</h3>
                <form action="process_support.php" method="POST" class="space-y-4">
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <label for="name" class="block text-gray-700 font-medium mb-2">Name</label>
                            <input type="text" id="name" name="name" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                        </div>
                        <div>
                            <label for="email" class="block text-gray-700 font-medium mb-2">Email</label>
                            <input type="email" id="email" name="email" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                        </div>
                    </div>
                    
                    <div>
                        <label for="subject" class="block text-gray-700 font-medium mb-2">Subject</label>
                        <select id="subject" name="subject" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                            <option value="">Select a topic</option>
                            <option value="general">General Inquiry</option>
                            <option value="cantesso">Cantesso Academy</option>
                            <option value="technical">Technical Support</option>
                            <option value="business">Business Partnership</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="message" class="block text-gray-700 font-medium mb-2">Message</label>
                        <textarea id="message" name="message" rows="4" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400" placeholder="Describe your question or issue..."></textarea>
                    </div>
                    
                    <button type="submit" class="bg-gray-800 text-white py-2 px-6 rounded-lg hover:bg-gray-700 transition duration-200 font-medium">
                        Send Message
                    </button>
                </form>
            </div>
        </section>
    </main>

    <div class="p-8 rounded">
        <blockquote class="border-l-4 border-gray-300 pl-6 py-4">
            <p class="text-xl font-light text-gray-700 mb-4">
                "Excellence in support means being there when our clients need us most."
            </p>
            <cite class="text-gray-500 text-sm">— Aktas Izhak, CEO aktascorp</cite>
        </blockquote>
    </div>

    <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
        <p>&copy; 2025 AktasCorporation. All rights reserved. AktasCorp is a company registered in the United States. For any request or contact with a manager, please contact us at msg@aktascorp.com</p>
    </footer>
</div>

</body>
</html>