<?php
require_once '../db.php';

header('Content-Type: application/json');

try {
    $status_filter = isset($_GET['status']) ? $_GET['status'] : '';
    
    $sql = "SELECT * FROM dossiers";
    $params = [];
    
    if (!empty($status_filter)) {
        $sql .= " WHERE statut = ?";
        $params[] = $status_filter;
    }
    
    $sql .= " ORDER BY date_ouverture DESC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $dossiers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($dossiers);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
}
?>