admin.php
<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('stock.json'), true);
    $trains = &$data['trains'];
    
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'add') {
            $trains[] = [
                'id' => uniqid(),
                'type' => $_POST['type'],
                'line' => $_POST['line'],
                'destination' => $_POST['destination'],
                'arrival' => $_POST['arrival'],
                'platform' => $_POST['platform'],
                'status' => 'on-time'
            ];
        } 
        elseif ($_POST['action'] === 'update') {
            $id = $_POST['id'];
            foreach ($trains as &$train) {
                if ($train['id'] === $id) {
                    $train['status'] = $_POST['status'];
                    $train['platform'] = $_POST['platform'];
                    break;
                }
            }
        }
        elseif ($_POST['action'] === 'delete') {
            $id = $_POST['id'];
            $trains = array_filter($trains, fn($t) => $t['id'] !== $id);
            $trains = array_values($trains);
        }
    }
    
    file_put_contents('stock.json', json_encode($data, JSON_PRETTY_PRINT));
    header('Location: admin.php');
    exit;
}

$data = json_decode(file_get_contents('stock.json'), true);
$trains = $data['trains'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration des Trains</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-black text-white">
    <div class="container mx-auto p-4">
        <header class="flex justify-between items-center mb-8">
            <h1 class="text-2xl font-light">Administration</h1>
            <a href="index.php" class="text-blue-400 hover:text-blue-300">← Affichage</a>
        </header>

        <!-- Formulaire d'ajout -->
        <form method="POST" class="bg-gray-900 p-4 rounded-lg mb-8">
            <input type="hidden" name="action" value="add">
            <div class="grid grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Type</label>
                    <select name="type" class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none">
                        <option>TGV</option>
                        <option>TER</option>
                        <option>Intercités</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Numéro</label>
                    <input type="text" name="line" class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" required>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Destination</label>
                    <input type="text" name="destination" class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" required>
                </div>
            </div>
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Heure d'arrivée</label>
                    <input type="datetime-local" name="arrival" class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" required>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Voie</label>
                    <input type="number" name="platform" min="1" max="99" class="w-full bg-gray-800 p-2 rounded border border-gray-700 focus:border-blue-500 focus:outline-none" required>
                </div>
            </div>
            <button type="submit" class="bg-blue-500 px-4 py-2 rounded hover:bg-blue-600">Ajouter</button>
        </form>

        <!-- Liste des trains -->
        <div class="space-y-4">
            <?php foreach ($trains as $train): 
                $arrival = new DateTime($train['arrival']);
                $now = new DateTime();
                $timeLeft = $arrival->getTimestamp() - $now->getTimestamp();
                if ($timeLeft < -1200) continue; // Cache les trains partis depuis plus de 20min
            ?>
            <div class="bg-gray-900 p-4 rounded-lg flex items-center justify-between">
                <div class="flex items-center gap-6">
                    <div class="px-3 py-1 bg-blue-900 rounded text-sm">
                        <?= $train['type'] ?> <?= htmlspecialchars($train['line']) ?>
                    </div>
                    <div>
                        <div class="font-light"><?= htmlspecialchars($train['destination']) ?></div>
                        <div class="text-sm text-gray-500">
                            <?= $arrival->format('H:i') ?> - 
                            Voie <?= htmlspecialchars($train['platform']) ?>
                        </div>
                    </div>
                </div>
                <div class="flex gap-4">
                    <form method="POST" class="flex gap-2">
                        <input type="hidden" name="action" value="update">
                        <input type="hidden" name="id" value="<?= $train['id'] ?>">
                        
                        <select name="status" class="bg-gray-800 px-3 py-1 rounded text-sm border border-gray-700">
                            <option value="on-time" <?= $train['status'] === 'on-time' ? 'selected' : '' ?>>À l'heure</option>
                            <option value="delayed" <?= $train['status'] === 'delayed' ? 'selected' : '' ?>>Retardé</option>
                        </select>
                        
                        <input type="number" name="platform" value="<?= $train['platform'] ?>" 
                            min="1" max="99" class="w-16 bg-gray-800 px-3 py-1 rounded text-sm border border-gray-700">
                        
                        <button type="submit" class="bg-green-600 px-3 py-1 rounded text-sm hover:bg-green-700">
                            Ok
                        </button>
                    </form>
                    
                    <form method="POST" class="flex" onsubmit="return confirm('Supprimer ce train ?')">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?= $train['id'] ?>">
                        <button type="submit" class="bg-red-600 px-3 py-1 rounded text-sm hover:bg-red-700">×</button>
                    </form>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <script>
    document.querySelectorAll('input[type="datetime-local"]').forEach(input => {
        if (!input.value) {
            const now = new Date();
            now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
            input.value = now.toISOString().slice(0,16);
        }
    });
    </script>
</body>
</html>