<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

if (!isset($_POST['folder']) || empty($_FILES['files'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Folder or files missing']);
    exit;
}

$folderName = $_POST['folder'];
$uploadDir = __DIR__ . '/assets/' . $folderName;

if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

$allowedExtensions = ['jpg', 'jpeg', 'png', 'mp4', 'mp3'];
$errors = [];
$success = [];

foreach ($_FILES['files']['tmp_name'] as $key => $tmpName) {
    $fileName = basename($_FILES['files']['name'][$key]);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $targetFile = $uploadDir . '/' . $fileName;

    if (!in_array($fileExt, $allowedExtensions)) {
        $errors[] = "Unsupported extension for $fileName";
        continue;
    }

    if (move_uploaded_file($tmpName, $targetFile)) {
        $success[] = $fileName;
    } else {
        $errors[] = "Failed to upload $fileName";
    }
}

if (!empty($errors)) {
    http_response_code(400);
    echo json_encode(['errors' => $errors, 'success' => $success]);
} else {
    echo json_encode(['success' => $success]);
}
?>
