<?php
// Inclure la connexion à la base de données
require_once 'db.php';

// Démarrer la session
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

// Créer le dossier uploads s'il n'existe pas
$uploadDir = 'assets/uploads/';
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// Traitement pour l'ajout d'une note
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_note'])) {
    $titre = $_POST['titre'];
    $matiere_id = $_POST['matiere_id'];
    $description = $_POST['description'];
    $user_id = $_SESSION['user_id'];
    $image_url = null;
    
    // Traitement de l'image si elle est fournie
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $tmpName = $_FILES['image']['tmp_name'];
        $fileName = uniqid() . '_' . $_FILES['image']['name'];
        $destination = $uploadDir . $fileName;
        
        // Déplacer l'image téléchargée
        if (move_uploaded_file($tmpName, $destination)) {
            $image_url = $destination;
        }
    }
    
    // Insérer la note dans la base de données
    $stmt = $pdo->prepare('INSERT INTO notes (user_id, matiere_id, titre, description, image_url) VALUES (?, ?, ?, ?, ?)');
    if ($stmt->execute([$user_id, $matiere_id, $titre, $description, $image_url])) {
        header('Location: index.php?success=note_added');
        exit;
    } else {
        header('Location: index.php?error=note_failed');
        exit;
    }
}

// Traitement pour l'ajout d'un commentaire
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_comment'])) {
    $note_id = $_POST['note_id'];
    $contenu = $_POST['contenu'];
    $user_id = $_SESSION['user_id'];
    
    // Vérifier que l'utilisateur est un professeur s'il tente d'ajouter un commentaire
    if ($_SESSION['role'] !== 'prof') {
        header('Location: index.php?error=not_authorized');
        exit;
    }
    
    // Insérer le commentaire
    $stmt = $pdo->prepare('INSERT INTO commentaires (note_id, user_id, contenu) VALUES (?, ?, ?)');
    if ($stmt->execute([$note_id, $user_id, $contenu])) {
        header('Location: index.php?success=comment_added');
        exit;
    } else {
        header('Location: index.php?error=comment_failed');
        exit;
    }
}

// Traitement pour l'ajout d'un examen
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_examen'])) {
    $titre = $_POST['titre_examen'];
    $date_debut = $_POST['date_debut'];
    $date_fin = $_POST['date_fin'];
    $debut_preparation = $_POST['debut_preparation'];
    $examens_blancs = $_POST['examens_blancs'];
    $user_id = $_SESSION['user_id'];
    $matieres = isset($_POST['matieres']) ? $_POST['matieres'] : [];
    
    // Vérifier que la date de fin est après la date de début
    if (strtotime($date_fin) < strtotime($date_debut)) {
        header('Location: index.php?error=invalid_dates');
        exit;
    }
    
    // Vérifier que la date de début de préparation est avant la date de début d'examen
    if (strtotime($debut_preparation) > strtotime($date_debut)) {
        header('Location: index.php?error=invalid_preparation');
        exit;
    }
    
    // Insérer l'examen
    try {
        $pdo->beginTransaction();
        
        // Insérer l'examen dans la table examens
        $stmt = $pdo->prepare('INSERT INTO examens (user_id, titre, date_debut, date_fin, debut_preparation, fin_preparation, nombre_examens_blancs) 
                               VALUES (?, ?, ?, ?, ?, ?, ?)');
        $stmt->execute([
            $user_id, 
            $titre, 
            $date_debut, 
            $date_fin, 
            $debut_preparation, 
            $date_debut, // Fin de préparation = début de l'examen
            $examens_blancs
        ]);
        
        $examen_id = $pdo->lastInsertId();
        
        // Insérer les matières associées à l'examen
        if (!empty($matieres)) {
            $stmt = $pdo->prepare('INSERT INTO examen_matieres (examen_id, matiere_id) VALUES (?, ?)');
            foreach ($matieres as $matiere_id) {
                $stmt->execute([$examen_id, $matiere_id]);
            }
        }
        
        $pdo->commit();
        header('Location: index.php?success=examen_added');
        exit;
    } catch (Exception $e) {
        $pdo->rollBack();
        header('Location: index.php?error=examen_failed');
        exit;
    }
}

// Traitement pour l'ajout d'un examen blanc
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_examen_blanc'])) {
    $examen_id = $_POST['examen_id'];
    $titre_blanc = $_POST['titre_blanc'];
    $date_blanc = $_POST['date_blanc'];
    $notes = isset($_POST['notes']) ? $_POST['notes'] : [];
    
    // Vérifier que l'utilisateur est un élève (admin) s'il tente d'ajouter un examen blanc
    if ($_SESSION['role'] !== 'eleve') {
        header('Location: index.php?error=not_authorized');
        exit;
    }
    
    // Vérifier que l'examen existe et appartient à l'utilisateur
    $stmt = $pdo->prepare('SELECT * FROM examens WHERE id = ? AND user_id = ?');
    $stmt->execute([$examen_id, $_SESSION['user_id']]);
    $examen = $stmt->fetch();
    
    if (!$examen) {
        header('Location: index.php?error=not_found');
        exit;
    }
    
    try {
        $pdo->beginTransaction();
        
        // Insérer l'examen blanc
        $stmt = $pdo->prepare('INSERT INTO examens_blancs (examen_id, titre, date) VALUES (?, ?, ?)');
        $stmt->execute([$examen_id, $titre_blanc, $date_blanc]);
        $examen_blanc_id = $pdo->lastInsertId();
        
        // Insérer les notes par matière
        if (!empty($notes)) {
            $stmt = $pdo->prepare('INSERT INTO examen_blanc_notes (examen_blanc_id, matiere_id, note, max_note) VALUES (?, ?, ?, ?)');
            
            foreach ($notes as $matiere_id => $note_data) {
                $note = $note_data['note'];
                $max_note = $note_data['max_note'];
                
                // Vérifier que la note ne dépasse pas la note maximale
                if ($note > $max_note) {
                    $note = $max_note;
                }
                
                $stmt->execute([$examen_blanc_id, $matiere_id, $note, $max_note]);
            }
        }
        
        $pdo->commit();
        header('Location: index.php?success=examen_blanc_added');
        exit;
    } catch (Exception $e) {
        $pdo->rollBack();
        header('Location: index.php?error=examen_blanc_failed');
        exit;
    }
}

// Si aucune action n'est effectuée, rediriger vers la page d'accueil
header('Location: index.php');
exit;