<div id="uploadPhotoModal" class="fixed inset-0 bg-black/95 backdrop-blur-sm hidden z-50">
    <div class="min-h-screen flex items-center justify-center p-4">
        <div class="bg-gray-800/50 backdrop-blur-sm rounded-2xl w-full max-w-lg">
            <form method="POST" enctype="multipart/form-data" class="p-6">
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-2xl font-bold">Upload Photo</h3>
                    <button type="button" onclick="this.closest('#uploadPhotoModal').classList.add('hidden')"
                            class="text-gray-400 hover:text-white p-2 rounded-full hover:bg-white/10 transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <div class="space-y-6">
                    <div>
                        <label class="block text-gray-300 text-sm font-bold mb-2">Photo</label>
                        <input type="file" name="photo" accept="image/*" required
                               class="w-full bg-gray-900/50 backdrop-blur-sm border-0 rounded-xl p-4 text-gray-300">
                    </div>

                    <div>
                        <label class="block text-gray-300 text-sm font-bold mb-2">Caption</label>
                        <textarea name="caption" rows="3"
                                  class="w-full bg-gray-900/50 backdrop-blur-sm border-0 rounded-xl p-4 text-white resize-none"
                                  placeholder="Add a caption to your photo..."></textarea>
                    </div>

                    <button type="submit" 
                            class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-xl transition-colors">
                        Upload Photo
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>