<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['error' => 'Non connecté']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$orderId = $input['orderId'];
$rating = $input['rating'];
$livreurId = $input['deliveryPersonId'];
$residentId = $_SESSION['resident_id'];

$query = "INSERT INTO delivery_ratings (order_id, livreur_id, resident_id, rating) VALUES (?, ?, ?, ?)";
$stmt = $conn->prepare($query);
$stmt->bind_param("iiii", $orderId, $livreurId, $residentId, $rating);
$stmt->execute();

$updateLivreurQuery = "UPDATE livreur SET rating = (SELECT AVG(rating) FROM delivery_ratings WHERE livreur_id = ?), total_deliveries = total_deliveries + 1 WHERE id = ?";
$stmt = $conn->prepare($updateLivreurQuery);
$stmt->bind_param("ii", $livreurId, $livreurId);
$stmt->execute();

echo json_encode(['success' => true]);
?>