<?php
include 'db.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header('Location: /media-mobile.php');
    exit;
}

$article = mysqli_query($conn, "SELECT *, DATE_FORMAT(date_publication, '%d/%m/%Y à %H:%i') as formatted_date FROM articles WHERE id = $id AND status = 'published'");

if (mysqli_num_rows($article) === 0) {
    header('Location: /media-mobile.php');
    exit;
}

$article = mysqli_fetch_assoc($article);

$related = mysqli_query($conn, "SELECT id, title FROM articles WHERE id != $id AND status = 'published' ORDER BY date_publication DESC LIMIT 3");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($article['title']) ?> - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <meta name="description" content="<?= htmlspecialchars(substr($article['excerpt'] ?? $article['content'], 0, 160)) ?>">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: { extend: {} }
        }
    </script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes scaleIn {
            from {
                opacity: 0;
                transform: scale(0.95);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        .animate-fade-in-up {
            animation: fadeInUp 0.8s ease-out forwards;
            opacity: 0;
        }

        .animate-scale-in {
            animation: scaleIn 0.6s ease-out forwards;
            opacity: 0;
        }

        .card {
            transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
            cursor: pointer;
            opacity: 0;
            animation: fadeInUp 0.6s ease-out forwards;
        }

        .card:hover {
            transform: translateY(-12px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .dark .card:hover {
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.5);
        }

        .article-content {
            line-height: 1.8;
        }
        .article-content p {
            margin-bottom: 1.5rem;
        }
        .article-content h2 {
            font-size: 1.5rem;
            font-weight: 500;
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        .article-content h3 {
            font-size: 1.25rem;
            font-weight: 500;
            margin-top: 1.5rem;
            margin-bottom: 0.75rem;
        }
        .article-content ul, .article-content ol {
            margin-left: 1.5rem;
            margin-bottom: 1.5rem;
        }
        .article-content li {
            margin-bottom: 0.5rem;
        }
        .article-content a {
            color: #6366f1;
            text-decoration: underline;
        }
        .article-content a:hover {
            color: #4f46e5;
        }
        .video-container {
            aspect-ratio: 9/16;
            max-width: 500px;
            margin: 0 auto;
        }
    </style>
</head>

<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
    </script>

    <main class="px-4 py-8 md:py-16 max-w-6xl mx-auto">
        <div class="flex flex-col items-center justify-center mb-8 md:mb-12 text-center relative">
            <div class="mb-8 animate-fade-in-up w-full max-w-4xl text-left">
                <a href="media-mobile.php" class="inline-flex items-center text-gray-500 dark:text-gray-400 hover:text-black dark:hover:text-white">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Retour aux actualités
                </a>
            </div>

            <?php if (!empty($article['video_url'])): ?>
            <div class="video-container mb-10 rounded-[20px] overflow-hidden w-full">
                <video controls class="w-full h-full object-cover">
                    <source src="<?= htmlspecialchars($article['video_url']) ?>" type="video/mp4">
                    Votre navigateur ne supporte pas la lecture de vidéos.
                </video>
            </div>
            <?php endif; ?>

            <h1 class="mt-4 md:mt-12 text-3xl md:text-5xl lg:text-6xl font-light text-stone-800 dark:text-white mb-2 md:mb-3 tracking-tight max-w-4xl">
                <?= htmlspecialchars($article['title']) ?>
            </h1>
            
            <div class="flex flex-wrap items-center justify-center gap-6 text-gray-500 dark:text-stone-400 text-sm mt-6">
                <div class="flex items-center">
                    <i class="fas fa-user mr-2"></i>
                    <span><?= htmlspecialchars($article['author']) ?></span>
                </div>
                
                <div class="flex items-center">
                    <i class="fas fa-calendar mr-2"></i>
                    <span><?= $article['formatted_date'] ?></span>
                </div>
                
                <?php if(!empty($article['category'])): ?>
                <div class="flex items-center">
                    <i class="fas fa-tag mr-2"></i>
                    <span><?= htmlspecialchars($article['category']) ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="mb-16 animate-fade-in-up max-w-4xl mx-auto" style="animation-delay: 0.2s">
            <div class="article-content prose prose-lg max-w-none dark:prose-invert text-gray-800 dark:text-gray-200">
                <?= nl2br(htmlspecialchars($article['content'])) ?>
            </div>
        </div>

        <?php if(mysqli_num_rows($related) > 0): ?>
        <section class="mb-20 max-w-4xl mx-auto">
            <div class="flex items-center gap-4 mb-10">
                <span class="text-xs font-bold uppercase tracking-widest text-gray-600 dark:text-gray-500">Articles similaires</span>
                <div class="h-px flex-1 bg-gradient-to-r from-gray-300 dark:from-gray-800 to-transparent"></div>
            </div>
            
            <div class="grid gap-7 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3">
                <?php
                $delay = 0;
                while($relatedArticle = mysqli_fetch_assoc($related)):
                ?>
                <article class="card bg-white dark:bg-stone-900 rounded-3xl overflow-hidden border border-gray-100 dark:border-stone-800 shadow-xl dark:shadow-stone-900/40"
                         style="animation-delay: <?= $delay ?>s">
                    
                    <div class="p-6">
                        <h3 class="text-xl font-semibold text-black dark:text-white mb-3"><?= htmlspecialchars($relatedArticle['title']) ?></h3>

                        <a href="/article-mobile.php?id=<?= $relatedArticle['id'] ?>" class="group block w-full text-center py-3.5 rounded-xl transition-all duration-300 text-sm font-semibold relative overflow-hidden bg-black dark:bg-white text-white dark:text-black hover:shadow-xl hover:scale-105">
                            <span class="flex items-center justify-center gap-2">
                                Lire l'article
                                <i class="fas fa-arrow-right text-xs transform group-hover:translate-x-1 transition-transform duration-300"></i>
                            </span>
                        </a>
                    </div>
                </article>
                <?php $delay += 0.08; ?>
                <?php endwhile; ?>
            </div>
        </section>
        <?php endif; ?>
        
        <div class="text-center mt-12 animate-fade-in-up max-w-4xl mx-auto" style="animation-delay: 0.7s">
            <p class="text-gray-600 dark:text-gray-400 text-sm">
                Une actualité à partager ? 
                <a href="mailto:msg@aktascorp.com" class="text-black dark:text-white font-semibold hover:underline transition-all duration-300">
                    Contacte-nous !
                </a>
            </p>
        </div>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.card').forEach(card => {
                card.addEventListener('click', function(e) {
                    const link = this.querySelector('a');
                    if (link && !e.target.closest('a')) {
                        window.location.href = link.href;
                    }
                });
            });
        });
    </script>
</body>
</html>