<?php
session_start();
include 'db.php';
include 'header-mobile.php';

if (!isset($_SESSION['resident_id'])) {
    header('Location: resident-login.php');
    exit;
}

$resident_id = $_SESSION['resident_id'];
$error_message = '';
$success_message = '';

$stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$resident = $stmt->get_result()->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['action'] == 'delete_account') {
    $password = $_POST['password'];
    $confirmation = $_POST['confirmation'];
    
    if ($confirmation !== 'SUPPRIMER') {
        $error_message = 'Vous devez taper exactement "SUPPRIMER" pour confirmer.';
    } elseif (!password_verify($password, $resident['password'])) {
        $error_message = 'Mot de passe incorrect.';
    } else {
        $conn->begin_transaction();
        
        try {
            $delete_stmt = $conn->prepare("DELETE FROM residents WHERE id = ?");
            $delete_stmt->bind_param("i", $resident_id);
            $delete_stmt->execute();
            
            $conn->commit();
            
            session_destroy();
            session_unset();
            
            if (isset($_COOKIE[session_name()])) {
                setcookie(session_name(), '', time() - 3600, '/');
            }
            
            header('Location: resident-login.php?deleted=1');
            exit;
            
        } catch (Exception $e) {
            $conn->rollback();
            $error_message = 'Erreur lors de la suppression du compte. Veuillez réessayer.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supprimer mon compte - Vert Chasseur</title>
    <link rel="icon" type="image/png" href="logo_new.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        @media (min-width: 768px) {
            body {
                background-image: url('font-homepage.png');
                background-size: cover;
                background-position: center;
                background-attachment: fixed;
                background-repeat: no-repeat;
            }
        }
        @media (max-width: 767px) {
            body {
                background-color: #ffffff !important;
                background-image: none !important;
            }
            .dark body {
                background-color: #000000 !important;
                background-image: none !important;
            }
        }
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-white dark:bg-black transition-colors duration-300">
    <script>
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>

<main class="min-h-screen px-4 py-8 md:py-16">
    <div class="max-w-2xl mx-auto">
        <div class="text-center mb-8">
            <a href="resident-dashboard.php" class="inline-flex items-center text-stone-600 dark:text-stone-400 hover:text-stone-800 dark:hover:text-stone-200 transition-colors mb-6">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
                Retour au tableau de bord
            </a>
            
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-2xl p-6 mb-8">
                <div class="flex items-center justify-center w-16 h-16 bg-red-100 dark:bg-red-900/40 rounded-full mx-auto mb-4">
                    <svg class="w-8 h-8 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"/>
                    </svg>
                </div>
                <h1 class="text-2xl md:text-3xl font-light text-red-800 dark:text-red-200 mb-2">Supprimer mon compte</h1>
                <p class="text-red-700 dark:text-red-300">Cette action est définitive et irréversible</p>
            </div>
        </div>

        <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg">
            <?php if ($error_message): ?>
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg mb-6">
                <?= htmlspecialchars($error_message) ?>
            </div>
            <?php endif; ?>

            <div class="mb-8">
                <h2 class="text-xl font-medium text-stone-900 dark:text-white mb-4">Conséquences de la suppression</h2>
                <div class="space-y-3 text-sm text-stone-600 dark:text-stone-400">
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        <p>Toutes tes informations personnelles seront définitivement supprimées</p>
                    </div>
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        <p>Tu perdras l'accès à toutes les offres exclusives du quartier</p>
                    </div>
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        <p>Aucune récupération de données ne sera possible</p>
                    </div>
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-red-500 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        <p>Tu devras créer un nouveau compte pour accéder de nouveau aux services</p>
                    </div>
                </div>
            </div>

            <form method="POST" class="space-y-6" onsubmit="return confirmDeletion()">
                <input type="hidden" name="action" value="delete_account">
                
                <div>
                    <label class="text-sm font-medium text-stone-700 dark:text-stone-300 block mb-2">
                        Confirme ton mot de passe actuel *
                    </label>
                    <input type="password" name="password" required
                           class="w-full px-3 py-2 border border-stone-300 dark:border-stone-600 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500">
                </div>
                
                <div>
                    <label class="text-sm font-medium text-stone-700 dark:text-stone-300 block mb-2">
                        Tape exactement "SUPPRIMER" pour confirmer *
                    </label>
                    <input type="text" name="confirmation" required placeholder="SUPPRIMER"
                           class="w-full px-3 py-2 border border-stone-300 dark:border-stone-600 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500">
                    <p class="text-xs text-stone-500 dark:text-stone-400 mt-1">Attention aux majuscules et à l'orthographe</p>
                </div>
                
                <div class="bg-stone-50 dark:bg-stone-800 p-4 rounded-lg">
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-stone-500 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <div>
                            <p class="text-sm font-medium text-stone-700 dark:text-stone-300">Compte supprimé : <?= htmlspecialchars($resident['first_name'] . ' ' . $resident['last_name']) ?></p>
                            <p class="text-xs text-stone-500 dark:text-stone-400">Email : <?= htmlspecialchars($resident['email']) ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="flex flex-col sm:flex-row gap-3">
                    <a href="resident-dashboard.php" 
                       class="flex-1 text-center bg-stone-200 dark:bg-stone-700 hover:bg-stone-300 dark:hover:bg-stone-600 text-stone-800 dark:text-stone-200 font-medium py-3 px-4 rounded-lg transition-colors">
                        Annuler
                    </a>
                    <button type="submit" 
                            class="flex-1 bg-red-600 hover:bg-red-700 text-white font-medium py-3 px-4 rounded-lg transition-colors">
                        Supprimer définitivement mon compte
                    </button>
                </div>
            </form>
        </div>
    </div>
</main>

<footer class="w-full py-4 md:py-6 border-t border-stone-200 dark:border-stone-800">
    <p class="text-xs text-stone-500 dark:text-stone-400 text-center px-4">
        © 2025 Vert Chasseur · 
        <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member
    </p>
</footer>

<script>
function confirmDeletion() {
    return confirm('Es-tu absolument certain de vouloir supprimer ton compte ? Cette action est irréversible.');
}
</script>

</body>
</html>