<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forum Post - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
        
        .comment {
            border-bottom: 1px solid #333;
        }
        
        .comment:last-child {
            border-bottom: none;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>
    
    <div class="container px-4 mx-auto py-12">
        <div class="mb-6 mt-12">
            <a href="/forum" class="text-link mb-8 inline-block"><i class="fas fa-arrow-left mr-2"></i> Back to Forum</a>
        </div>
        
        <?php
        require_once 'db.php';
        
        if(!isset($_GET['id']) || !is_numeric($_GET['id'])) {
            echo '<div class="text-center py-10">
                <h2 class="text-2xl font-light mb-4">Post Not Found</h2>
                <p class="text-gray-400 mb-6">The post you\'re looking for doesn\'t exist or has been removed.</p>
                <a href="/forum" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Back to Forum</a>
            </div>';
            exit;
        }
        
        $post_id = (int)$_GET['id'];
        
        try {
            $update_views = "UPDATE posts SET views = views + 1 WHERE id = :post_id";
            $stmt = $conn->prepare($update_views);
            $stmt->bindParam(':post_id', $post_id, PDO::PARAM_INT);
            $stmt->execute();
            
            $query = "SELECT p.id, p.title, p.content, p.created_at, p.views, p.user_id
                     FROM posts p
                     WHERE p.id = :post_id";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':post_id', $post_id, PDO::PARAM_INT);
            $stmt->execute();
            $post = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($post) {
                $post_date = date("F j, Y", strtotime($post["created_at"]));
                ?>
                
                <article class="mb-10">
                    <h1 class="text-4xl font-light mb-4"><?php echo htmlspecialchars($post["title"]); ?></h1>
                    
                    <div class="flex items-center mb-6">
                        <?php
                        $user_id = $post["user_id"];
                        try {
                            $user_query = "SELECT username, `profile-picture` as profile_picture FROM utilisateurs WHERE id = :user_id";
                            $user_stmt = $conn->prepare($user_query);
                            $user_stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
                            $user_stmt->execute();
                            $user = $user_stmt->fetch(PDO::FETCH_ASSOC);
                            $username = $user ? htmlspecialchars($user["username"]) : "Unknown";
                            $profile_picture = $user ? $user["profile_picture"] : "";
                        } catch (Exception $e) {
                            $username = "User #" . $user_id;
                            $profile_picture = "";
                        }
                        ?>
                        <div class="w-10 h-10 rounded-full overflow-hidden mr-3">
                            <?php if($profile_picture): ?>
                                <img src="<?php echo htmlspecialchars($profile_picture); ?>" alt="<?php echo $username; ?>" class="w-full h-full object-cover">
                            <?php else: ?>
                                <div class="w-full h-full bg-gray-700 flex items-center justify-center">
                                    <span class="text-sm"><?php echo strtoupper(substr($username, 0, 1)); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div>
                            <p class="font-medium"><?php echo $username; ?></p>
                            <p class="text-sm text-gray-400"><?php echo $post_date; ?></p>
                        </div>
                        <div class="ml-auto text-sm text-gray-400">
                            <span class="mr-4"><i class="far fa-eye mr-1"></i> <?php echo $post["views"]; ?> views</span>
                        </div>
                    </div>
                    
                    <div class="post-content text-gray-300 leading-relaxed">
                        <?php echo nl2br(htmlspecialchars($post["content"])); ?>
                    </div>
                </article>
                
                <div class="separator"></div>
                
                <div class="py-8">
                    <h2 class="text-2xl font-light mb-6">Comments</h2>
                    
                    <?php
                    $comments_query = "SELECT c.id, c.content, c.created_at, c.user_id 
                                      FROM comments c
                                      WHERE c.post_id = :post_id
                                      ORDER BY c.created_at ASC";
                    $comments_stmt = $conn->prepare($comments_query);
                    $comments_stmt->bindParam(':post_id', $post_id, PDO::PARAM_INT);
                    $comments_stmt->execute();
                    $comments = $comments_stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    if (count($comments) > 0) {
                        foreach($comments as $comment) {
                            $comment_date = date("M j, Y", strtotime($comment["created_at"]));
                            ?>
                            
                            <div class="comment py-6">
                                <div class="flex items-start">
                                    <?php
                                    $commenter_id = $comment["user_id"];
                                    try {
                                        $commenter_query = "SELECT username, `profile-picture` as profile_picture FROM utilisateurs WHERE id = :user_id";
                                        $commenter_stmt = $conn->prepare($commenter_query);
                                        $commenter_stmt->bindParam(':user_id', $commenter_id, PDO::PARAM_INT);
                                        $commenter_stmt->execute();
                                        $commenter = $commenter_stmt->fetch(PDO::FETCH_ASSOC);
                                        $commenter_name = $commenter ? htmlspecialchars($commenter["username"]) : "Unknown";
                                        $commenter_pic = $commenter ? $commenter["profile_picture"] : "";
                                    } catch (Exception $e) {
                                        $commenter_name = "User #" . $commenter_id;
                                        $commenter_pic = "";
                                    }
                                    ?>
                                    <div class="w-10 h-10 rounded-full overflow-hidden mr-3">
                                        <?php if($commenter_pic): ?>
                                            <img src="<?php echo htmlspecialchars($commenter_pic); ?>" alt="<?php echo $commenter_name; ?>" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <div class="w-full h-full bg-gray-700 flex items-center justify-center">
                                                <span class="text-sm"><?php echo strtoupper(substr($commenter_name, 0, 1)); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex-1">
                                        <div class="flex justify-between items-center mb-2">
                                            <p class="font-medium"><?php echo $commenter_name; ?></p>
                                            <p class="text-sm text-gray-400"><?php echo $comment_date; ?></p>
                                        </div>
                                        <div class="text-gray-300">
                                            <?php echo nl2br(htmlspecialchars($comment["content"])); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php
                        }
                    } else {
                        echo '<div class="text-center py-8">
                            <p class="text-gray-400">No comments yet. Be the first to share your thoughts!</p>
                        </div>';
                    }
                    ?>
                    
                    <div class="mt-10">
                        <?php if(isset($_SESSION['user_id'])): ?>
                            <h3 class="text-xl font-light mb-4">Leave a Comment</h3>
                            <form action="/post-comment.php" method="post" class="mt-4">
                                <input type="hidden" name="post_id" value="<?php echo $post_id; ?>">
                                <textarea name="content" rows="4" class="w-full bg-gray-800 border border-gray-700 rounded-md p-3 text-white focus:outline-none focus:border-gray-500" placeholder="Share your thoughts..." required></textarea>
                                <button type="submit" class="mt-4 bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Post Comment</button>
                            </form>
                        <?php else: ?>
                            <div class="bg-gray-800 rounded-md p-6 text-center">
                                <p class="text-gray-300 mb-4">You must be logged in to comment</p>
                                <a href="/login" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Log In</a>
                                <span class="mx-2 text-gray-500">or</span>
                                <a href="/register" class="text-link">Create an Account</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <?php
            } else {
                echo '<div class="text-center py-10">
                    <h2 class="text-2xl font-light mb-4">Post Not Found</h2>
                    <p class="text-gray-400 mb-6">The post you\'re looking for doesn\'t exist or has been removed.</p>
                    <a href="/forum" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Back to Forum</a>
                </div>';
            }
        } catch (Exception $e) {
            echo '<div class="text-center py-10">
                <h2 class="text-2xl font-light mb-4">Error Loading Post</h2>
                <p class="text-gray-400 mb-6">There was an error loading this post. Please try again later.</p>
                <a href="/forum" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Back to Forum</a>
            </div>';
        }
        ?>
    </div>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>