<?php
require_once 'db.php';

$article = null;

if(isset($_GET['id'])) {
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $stmt = $pdo->prepare("SELECT * FROM articles WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $article = $stmt->fetch(PDO::FETCH_ASSOC);
        
    } catch(PDOException $e) {
        $error = 'Database connection failed: ' . $e->getMessage();
    }
} elseif(isset($_GET['title'])) {
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $slug = $_GET['title'];
        $stmt = $pdo->prepare("SELECT * FROM articles WHERE LOWER(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(title, ' ', '-'), '?', ''), '!', ''), '.', ''), ',', ''), ':', '')) = ?");
        $stmt->execute([strtolower($slug)]);
        $article = $stmt->fetch(PDO::FETCH_ASSOC);
        
    } catch(PDOException $e) {
        $error = 'Database connection failed: ' . $e->getMessage();
    }
}

function createSlug($title) {
    $slug = strtolower($title);
    $slug = str_replace(' ', '-', $slug);
    $slug = preg_replace('/[^a-z0-9\-]/', '', $slug);
    $slug = preg_replace('/-+/', '-', $slug);
    $slug = trim($slug, '-');
    return $slug;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $article ? htmlspecialchars($article['title']) : 'Article not found'; ?> - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
            margin: 0;
            padding: 0;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .slide-up {
            opacity: 0;
            animation: slideUp 0.6s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }

        .delay-1 {animation-delay: 0.1s;}
        .delay-2 {animation-delay: 0.2s;}
        .delay-3 {animation-delay: 0.3s;}

        .article-header {
            padding: 4rem 2rem 2rem;
            text-align: center;
            max-width: 800px;
            margin: 0 auto;
        }

        .article-content {
            max-width: 800px;
            margin: 0 auto;
            padding: 0 2rem 4rem;
            line-height: 1.8;
            font-size: 1.1rem;
        }

        .article-meta {
            text-align: center;
            opacity: 0.6;
            font-size: 0.9rem;
            margin-bottom: 3rem;
        }

        .button-custom {
            background-color: var(--text-light);
            color: var(--bg-light);
            padding: 1rem 2rem;
            border-radius: 2rem;
            font-size: 0.9rem;
            font-weight: 300;
            letter-spacing: 0.05em;
            transition: opacity 0.2s ease;
            text-decoration: none;
            display: inline-block;
        }

        @media (prefers-color-scheme: dark) {
            .button-custom {
                background-color: var(--text-dark);
                color: var(--bg-dark);
            }
        }

        .button-custom:hover {
            opacity: 0.8;
        }

        @media (max-width: 768px) {
            .article-header {
                padding: 2rem 1rem 1rem;
            }
            
            .article-content {
                padding: 0 1rem 3rem;
                font-size: 1rem;
            }
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-6 sticky top-0 z-50 slide-up">
        <div class="max-width-1200px mx-auto px-6">
            <div class="flex justify-between items-center">
                <h1 class="text-2xl font-light tracking-tight">Izhak</h1>
                <a href="/post" class="text-sm font-light hover:opacity-70 transition-opacity">← Back to Blog</a>
            </div>
        </div>
    </header>

    <?php if($article): ?>
        <article class="slide-up delay-1">
            <div class="article-header">
                <h1 class="text-4xl md:text-5xl font-light tracking-tight mb-4"><?php echo htmlspecialchars($article['title']); ?></h1>
                <div class="article-meta">
                    Published on <?php echo date('F d, Y', strtotime($article['date_created'])); ?>
                </div>
            </div>
            
            <div class="article-content slide-up delay-2">
                <?php echo nl2br(htmlspecialchars($article['content'])); ?>
            </div>
        </article>
    <?php else: ?>
        <div class="article-header slide-up delay-1">
            <h1 class="text-4xl md:text-5xl font-light tracking-tight mb-4">Article not found</h1>
            <p class="text-lg font-light opacity-70 mb-8">The article you're looking for doesn't exist or has been removed.</p>
            <a href="blog.php" class="button-custom">Back to Blog</a>
        </div>
    <?php endif; ?>

    <footer class="py-8 text-center text-sm font-light opacity-50">
        <p>Designed with a smile.</p>
    </footer>
</body>
</html>