<?php
require_once __DIR__ . '/vendor/autoload.php';
require_once 'db.php';

$stripe_config = require 'config/stripe.php';
\Stripe\Stripe::setApiKey($stripe_config['secret_key']);

$endpoint_secret = $stripe_config['webhook_secret'];

$payload = @file_get_contents('php://input');
$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
$event = null;

try {
    $event = \Stripe\Webhook::constructEvent($payload, $sig_header, $endpoint_secret);
} catch(\UnexpectedValueException $e) {
    http_response_code(400);
    exit();
} catch(\Stripe\Exception\SignatureVerificationException $e) {
    http_response_code(400);
    exit();
}

switch ($event->type) {
    case 'invoice.payment_succeeded':
        $invoice = $event->data->object;
        $subscription_id = $invoice->subscription;
        
        $stmt = $conn->prepare("SELECT resident_id, id FROM subscriptions WHERE stripe_subscription_id = ?");
        $stmt->bind_param("s", $subscription_id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        
        if ($result) {
            $update = $conn->prepare("UPDATE subscriptions SET status = 'active' WHERE stripe_subscription_id = ?");
            $update->bind_param("s", $subscription_id);
            $update->execute();
            
            $update_member = $conn->prepare("UPDATE residents SET member_ = 1 WHERE id = ?");
            $update_member->bind_param("i", $result['resident_id']);
            $update_member->execute();
            
            $payment_stmt = $conn->prepare("INSERT INTO payment_history (resident_id, subscription_id, stripe_payment_intent_id, amount, currency, status, payment_date) VALUES (?, ?, ?, ?, ?, ?, NOW())");
            $amount = $invoice->amount_paid / 100;
            $currency = $invoice->currency;
            $status = 'succeeded';
            $payment_intent_id = $invoice->payment_intent;
            $payment_stmt->bind_param("iisdss", 
                $result['resident_id'], 
                $result['id'], 
                $payment_intent_id, 
                $amount, 
                $currency, 
                $status
            );
            $payment_stmt->execute();
        }
        break;
        
    case 'customer.subscription.updated':
        $subscription = $event->data->object;
        
        $stmt = $conn->prepare("UPDATE subscriptions SET status = ?, current_period_start = FROM_UNIXTIME(?), current_period_end = FROM_UNIXTIME(?), cancel_at_period_end = ? WHERE stripe_subscription_id = ?");
        $status = $subscription->status;
        $cancel_at = $subscription->cancel_at_period_end ? 1 : 0;
        $stmt->bind_param("siiis", 
            $status, 
            $subscription->current_period_start, 
            $subscription->current_period_end, 
            $cancel_at, 
            $subscription->id
        );
        $stmt->execute();
        
        if ($subscription->status !== 'active') {
            $member_stmt = $conn->prepare("UPDATE residents r JOIN subscriptions s ON r.id = s.resident_id SET r.member_ = 0 WHERE s.stripe_subscription_id = ?");
            $member_stmt->bind_param("s", $subscription->id);
            $member_stmt->execute();
        }
        break;
        
    case 'customer.subscription.deleted':
        $subscription = $event->data->object;
        
        $stmt = $conn->prepare("UPDATE subscriptions SET status = 'canceled' WHERE stripe_subscription_id = ?");
        $stmt->bind_param("s", $subscription->id);
        $stmt->execute();
        
        $member_stmt = $conn->prepare("UPDATE residents r JOIN subscriptions s ON r.id = s.resident_id SET r.member_ = 0 WHERE s.stripe_subscription_id = ?");
        $member_stmt->bind_param("s", $subscription->id);
        $member_stmt->execute();
        break;
}

http_response_code(200);